/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.models;

import java.util.ArrayList;
import java.util.List;
import network.minter.core.crypto.EncryptedString;
import network.minter.core.crypto.HashUtil;
import network.minter.core.internal.common.Preconditions;
import network.minter.profile.models.ProfileAddressData;
import org.parceler.Parcel;

@Parcel
public class PasswordChangeRequest {
    public String newPassword;
    public List<EncryptedData> addressesEncryptedData;

    public void setRawPassword(String password) {
        Preconditions.checkNotNull((Object)password);
        this.newPassword = HashUtil.sha256HexDouble((String)password);
    }

    public void addEncrypted(ProfileAddressData data) {
        if (this.addressesEncryptedData == null) {
            this.addressesEncryptedData = new ArrayList<EncryptedData>();
        }
        EncryptedData d = new EncryptedData();
        d.id = data.id;
        d.encrypted = data.encrypted;
        this.addressesEncryptedData.add(d);
    }

    public void addEncrypted(List<ProfileAddressData> items) {
        for (ProfileAddressData d : items) {
            this.addEncrypted(d);
        }
    }

    @Parcel
    public static final class EncryptedData {
        public String id;
        public EncryptedString encrypted;
    }
}

