/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.EncryptedString;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringSerializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterAddressSerializer;
import network.minter.core.internal.api.converters.UriDeserializer;
import network.minter.core.internal.common.CallbackProvider;
import network.minter.core.internal.common.Preconditions;
import network.minter.profile.repo.ProfileAddressRepository;
import network.minter.profile.repo.ProfileAuthRepository;
import network.minter.profile.repo.ProfileInfoRepository;
import network.minter.profile.repo.ProfileRepository;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterProfileApi {
    private static final String BASE_API_URL = "https://my.beta.minter.network";
    private static MinterProfileApi INSTANCE;
    private ApiService.Builder mApiService = new ApiService.Builder("https://my.beta.minter.network", this.getGsonBuilder());
    private ProfileAuthRepository mAuthRepository;
    private ProfileInfoRepository mInfoRepository;
    private ProfileAddressRepository mAddressRepository;
    private ProfileRepository mProfileRepository;

    private MinterProfileApi(CallbackProvider<String> token) {
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (profile)");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.1.2");
        this.mApiService.setDateFormat("yyyy-MM-dd HH:mm:ssX");
        this.mApiService.setAuthHeaderName("Authorization");
        this.mApiService.setTokenGetter(() -> {
            if (token == null) {
                return null;
            }
            return "Bearer " + (String)token.get();
        });
    }

    public static void initialize(CallbackProvider<String> token) {
        MinterProfileApi.initialize(token, false);
    }

    public static void initialize(CallbackProvider<String> token, boolean debug) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterProfileApi(token);
        MinterProfileApi.INSTANCE.mApiService.setDebug(debug);
        MinterProfileApi.INSTANCE.mApiService.setDebugRequestLevel(debug ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    public static String getCoinAvatarUrl(@NonNull String coinName) {
        Preconditions.checkNotNull((Object)coinName, (String)"Coin name can't be null");
        Preconditions.checkArgument((coinName.length() >= 3 && coinName.length() <= 10 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 chars");
        return "https://my.beta.minter.network/api/v1/avatar/by/coin/" + coinName.toUpperCase();
    }

    public static String getUserAvatarUrl(long id) {
        return MinterProfileApi.getUserAvatarUrl(String.valueOf(id));
    }

    public static String getUserAvatarUrl(String id) {
        Preconditions.checkNotNull((Object)id, (String)"Id required");
        return "https://my.beta.minter.network/api/v1/avatar/by/user/" + id;
    }

    public static MinterProfileApi getInstance() {
        return INSTANCE;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressSerializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        out.registerTypeAdapter(EncryptedString.class, (Object)new EncryptedStringDeserializer());
        out.registerTypeAdapter(EncryptedString.class, (Object)new EncryptedStringSerializer());
        out.registerTypeAdapter(Uri.class, (Object)new UriDeserializer());
        return out;
    }

    public ProfileAuthRepository auth() {
        if (this.mAuthRepository == null) {
            this.mAuthRepository = new ProfileAuthRepository(this.mApiService);
        }
        return this.mAuthRepository;
    }

    public ProfileInfoRepository info() {
        if (this.mInfoRepository == null) {
            this.mInfoRepository = new ProfileInfoRepository(this.mApiService);
        }
        return this.mInfoRepository;
    }

    public ProfileAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ProfileAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public ProfileRepository profile() {
        if (this.mProfileRepository == null) {
            this.mProfileRepository = new ProfileRepository(this.mApiService);
        }
        return this.mProfileRepository;
    }
}

