/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.GateEstimateEndpoint;
import network.minter.explorer.models.CoinItemBase;
import network.minter.explorer.models.GateResult;
import network.minter.explorer.models.TxCount;

public class GateEstimateRepository
extends DataRepository<GateEstimateEndpoint>
implements DataRepository.Configurator {
    public GateEstimateRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Observable<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(CoinItemBase comparable, BigDecimal number, CoinItemBase coinItemBase) {
        GateEstimateRepository gateEstimateRepository = object;
        Object object = comparable.id;
        comparable = number.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        number = coinItemBase.id;
        return gateEstimateRepository.getCoinExchangeCurrencyToSell((BigInteger)object, (BigInteger)comparable, (BigInteger)number);
    }

    public Observable<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(BigInteger bigInteger, BigDecimal bigDecimal, BigInteger bigInteger2) {
        return this.getCoinExchangeCurrencyToSell(bigInteger, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), bigInteger2);
    }

    public Observable<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(BigInteger object, BigInteger object2, BigInteger bigInteger) {
        GateEstimateEndpoint gateEstimateEndpoint = (GateEstimateEndpoint)object3.getInstantService();
        Object object3 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin ID required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Target coin ID required")).toString();
        return gateEstimateEndpoint.getCoinExchangeCurrencyToSellById((String)object3, (String)object, (String)object2);
    }

    public Observable<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(String string, BigDecimal bigDecimal, String string2) {
        return this.getCoinExchangeCurrencyToSell(string, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), string2);
    }

    public Observable<GateResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(String string, BigInteger object, String string2) {
        GateEstimateEndpoint gateEstimateEndpoint = (GateEstimateEndpoint)object2.getInstantService();
        Object object2 = ((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase();
        string = ((BigInteger)object).toString();
        object = ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase();
        return gateEstimateEndpoint.getCoinExchangeCurrencyToSell((String)object2, string, (String)object);
    }

    public Observable<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(CoinItemBase comparable, BigDecimal number, CoinItemBase coinItemBase) {
        GateEstimateRepository gateEstimateRepository = object;
        Object object = comparable.id;
        comparable = number.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        number = coinItemBase.id;
        return gateEstimateRepository.getCoinExchangeCurrencyToBuy((BigInteger)object, (BigInteger)comparable, (BigInteger)number);
    }

    public Observable<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(BigInteger bigInteger, BigDecimal bigDecimal, BigInteger bigInteger2) {
        return this.getCoinExchangeCurrencyToBuy(bigInteger, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), bigInteger2);
    }

    public Observable<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(BigInteger object, BigInteger object2, BigInteger bigInteger) {
        GateEstimateEndpoint gateEstimateEndpoint = (GateEstimateEndpoint)object3.getInstantService();
        Object object3 = ((BigInteger)Preconditions.checkNotNull((Object)object, (String)"Source coin ID required")).toString();
        object = ((BigInteger)object2).toString();
        object2 = ((BigInteger)Preconditions.checkNotNull((Object)bigInteger, (String)"Target coin ID required")).toString();
        return gateEstimateEndpoint.getCoinExchangeCurrencyToBuyById((String)object3, (String)object, (String)object2);
    }

    public Observable<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigDecimal bigDecimal, @Nonnull String string2) {
        return this.getCoinExchangeCurrencyToBuy(string, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), string2);
    }

    public Observable<GateResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigInteger object, @Nonnull String string2) {
        GateEstimateEndpoint gateEstimateEndpoint = (GateEstimateEndpoint)object2.getInstantService();
        Object object2 = ((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase();
        string = ((BigInteger)object).toString();
        object = ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase();
        return gateEstimateEndpoint.getCoinExchangeCurrencyToBuy((String)object2, string, (String)object);
    }

    public Observable<GateResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign transactionSign) {
        Preconditions.checkArgument((transactionSign != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return this.getTransactionCommission(transactionSign.getTxSign());
    }

    public Observable<GateResult<TransactionCommissionValue>> getTransactionCommission(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Transaction signature required!");
        return ((GateEstimateEndpoint)this.getInstantService()).getTxCommission(string);
    }

    public Observable<GateResult<TxCount>> getTransactionCount(@Nonnull MinterAddress minterAddress) {
        Preconditions.checkArgument((minterAddress != null ? 1 : 0) != 0, (Object)"Address can't be null");
        return this.getTransactionCount(minterAddress.toString());
    }

    public Observable<GateResult<TxCount>> getTransactionCount(@Nonnull String string) {
        return ((GateEstimateEndpoint)this.getInstantService()).getTransactionsCount((String)Preconditions.checkNotNull((Object)string, (String)"Address required!"));
    }

    @Nonnull
    protected Class<GateEstimateEndpoint> getServiceClass() {
        return GateEstimateEndpoint.class;
    }

    public void configure(ApiService.Builder object) {
        GateResult.Deserializer<TxCount> deserializer;
        GateResult.Deserializer<ExchangeBuyValue> deserializer2;
        GateResult.Deserializer<ExchangeBuyValue> deserializer3;
        GateResult.Deserializer<ExchangeBuyValue> deserializer4;
        ApiService.Builder builder = object;
        object = new TypeToken<GateResult<TransactionCommissionValue>>(object2){}.getType();
        GateResult.Deserializer<ExchangeBuyValue> deserializer5 = deserializer4;
        deserializer4 = new GateResult.Deserializer<ExchangeBuyValue>(TransactionCommissionValue.class);
        builder.registerTypeAdapter((Type)object, deserializer5);
        object = new TypeToken<GateResult<ExchangeSellValue>>(object2){}.getType();
        deserializer5 = deserializer3;
        deserializer3 = new GateResult.Deserializer<ExchangeBuyValue>(ExchangeSellValue.class);
        builder.registerTypeAdapter((Type)object, deserializer5);
        object = new TypeToken<GateResult<ExchangeBuyValue>>(object2){}.getType();
        deserializer5 = deserializer2;
        deserializer2 = new GateResult.Deserializer<ExchangeBuyValue>(ExchangeBuyValue.class);
        builder.registerTypeAdapter((Type)object, deserializer5);
        Object object2 = new TypeToken<GateResult<TxCount>>(object2){}.getType();
        object = deserializer;
        deserializer = new GateResult.Deserializer<TxCount>(TxCount.class);
        builder.registerTypeAdapter((Type)object2, object);
    }
}

