/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.api.converters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.minter.core.crypto.MinterAddress;
import network.minter.explorer.models.AddressBalance;
import network.minter.explorer.models.CoinBalance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lnetwork/minter/explorer/api/converters/ExplorerAddressBalanceDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lnetwork/minter/explorer/models/AddressBalance;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "Companion", "minter-android-explorer_netTestRelease"})
public final class ExplorerAddressBalanceDeserializer
implements JsonDeserializer<AddressBalance> {
    private static final String COINS_BALANCE = "balances";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public AddressBalance deserialize(@NotNull JsonElement jsonElement, @NotNull Type object, @NotNull JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        AddressBalance addressBalance;
        Intrinsics.checkParameterIsNotNull((Object)jsonElement, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)jsonDeserializationContext, (String)"context");
        if (jsonElement.isJsonNull()) {
            return null;
        }
        AddressBalance addressBalance2 = addressBalance;
        addressBalance = new AddressBalance();
        if ((jsonElement = jsonElement.getAsJsonObject()).has("address")) {
            JsonElement jsonElement2 = jsonElement.get("address");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"root[\"address\"]");
            if (!jsonElement2.isJsonNull()) {
                JsonElement jsonElement3 = jsonElement.get("address");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"root[\"address\"]");
                addressBalance2.address = new MinterAddress((CharSequence)jsonElement3.getAsString());
            }
        }
        if (jsonElement.has("total_balance_sum")) {
            JsonElement jsonElement4 = jsonElement.get("total_balance_sum");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"root[\"total_balance_sum\"]");
            if (!jsonElement4.isJsonNull()) {
                JsonElement jsonElement5 = jsonElement.get("total_balance_sum");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"root[\"total_balance_sum\"]");
                addressBalance2.totalBalance = jsonElement5.getAsBigDecimal();
            }
        }
        if (jsonElement.has("total_balance_sum_usd")) {
            JsonElement jsonElement6 = jsonElement.get("total_balance_sum_usd");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"root[\"total_balance_sum_usd\"]");
            if (!jsonElement6.isJsonNull()) {
                JsonElement jsonElement7 = jsonElement.get("total_balance_sum_usd");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement7, (String)"root[\"total_balance_sum_usd\"]");
                addressBalance2.totalBalanceUSD = jsonElement7.getAsBigDecimal();
            }
        }
        if (jsonElement.has("available_balance_sum")) {
            JsonElement jsonElement8 = jsonElement.get("available_balance_sum");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement8, (String)"root[\"available_balance_sum\"]");
            if (!jsonElement8.isJsonNull()) {
                JsonElement jsonElement9 = jsonElement.get("available_balance_sum");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement9, (String)"root[\"available_balance_sum\"]");
                addressBalance2.availableBalanceBIP = jsonElement9.getAsBigDecimal();
            }
        }
        if (jsonElement.has("available_balance_sum_usd")) {
            JsonElement jsonElement10 = jsonElement.get("available_balance_sum_usd");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement10, (String)"root[\"available_balance_sum_usd\"]");
            if (!jsonElement10.isJsonNull()) {
                JsonElement jsonElement11 = jsonElement.get("available_balance_sum_usd");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement11, (String)"root[\"available_balance_sum_usd\"]");
                addressBalance2.availableBalanceUSD = jsonElement11.getAsBigDecimal();
            }
        }
        if (jsonElement.has(COINS_BALANCE)) {
            HashMap hashMap;
            jsonElement = jsonElement.getAsJsonArray(COINS_BALANCE);
            object = hashMap;
            hashMap = new HashMap();
            int n = jsonElement.size();
            for (int i = 0; i < n; ++i) {
                JsonElement jsonElement12 = jsonElement.get(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement12, (String)"coins[i]");
                JsonObject jsonObject = jsonElement12.getAsJsonObject();
                JsonElement jsonElement13 = jsonObject.get("amount");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement13, (String)"coinData[\"amount\"]");
                BigDecimal bigDecimal = jsonElement13.getAsBigDecimal();
                JsonElement jsonElement14 = jsonObject.get("bip_amount");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement14, (String)"coinData[\"bip_amount\"]");
                BigDecimal bigDecimal2 = jsonElement14.getAsBigDecimal();
                JsonElement jsonElement15 = jsonObject.get("coin");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement15, (String)"coinData[\"coin\"]");
                String string = jsonElement15.getAsString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coinData[\"coin\"].asString");
                Object object2 = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"Locale.getDefault()");
                if (string != null) {
                    CoinBalance coinBalance;
                    string = string.toUpperCase((Locale)object2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
                    object2 = coinBalance;
                    MinterAddress minterAddress = addressBalance2.address;
                    coinBalance = new CoinBalance(string, bigDecimal, bigDecimal2, minterAddress);
                    object.put(string, object2);
                    continue;
                }
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            addressBalance2.coins = object;
        }
        return addressBalance2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnetwork/minter/explorer/api/converters/ExplorerAddressBalanceDeserializer$Companion;", "", "()V", "COINS_BALANCE", "", "minter-android-explorer_netTestRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

