/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer;

import android.os.Build;
import android.util.Log;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerJsonConverter;
import network.minter.core.internal.api.converters.BytesDataJsonConverter;
import network.minter.core.internal.api.converters.MinterAddressJsonConverter;
import network.minter.core.internal.api.converters.MinterCheckJsonConverter;
import network.minter.core.internal.api.converters.MinterHashJsonConverter;
import network.minter.core.internal.api.converters.MinterPublicKeyJsonConverter;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.StdLogger;
import network.minter.core.internal.log.TimberLogger;
import network.minter.explorer.repo.ExplorerAddressRepository;
import network.minter.explorer.repo.ExplorerCoinsRepository;
import network.minter.explorer.repo.ExplorerTransactionRepository;
import network.minter.explorer.repo.ExplorerValidatorsRepository;
import network.minter.explorer.repo.GateEstimateRepository;
import network.minter.explorer.repo.GateGasRepository;
import network.minter.explorer.repo.GateTransactionRepository;
import okhttp3.HttpUrl;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterExplorerApi {
    public static final String FRONT_URL = "https://testnet.explorer.minter.network";
    private static final String BASE_API_URL = "https://explorer-api.testnet.minter.network/api/";
    private static final String BASE_GATE_URL = "https://gate.minter.network/api/";
    private static final String DATE_FORMAT;
    private static MinterExplorerApi INSTANCE;
    private ApiService.Builder mApiService;
    private ApiService.Builder mGateApiService;
    private ExplorerTransactionRepository mTransactionRepository;
    private ExplorerAddressRepository mAddressRepository;
    private ExplorerCoinsRepository mCoinsRepository;
    private ExplorerValidatorsRepository mValidatorsRepository;
    private GateGasRepository mGasRepository;
    private GateEstimateRepository mGateEstimateRepo;
    private GateTransactionRepository mGateTxRepo;

    private MinterExplorerApi() {
        this(BASE_API_URL, BASE_GATE_URL);
    }

    private MinterExplorerApi(String string, String string2) {
        MinterExplorerApi minterExplorerApi = this;
        minterExplorerApi.mApiService = new ApiService.Builder(string, this.getGsonBuilder());
        minterExplorerApi.mApiService.addHeader("Content-Type", "application/json");
        minterExplorerApi.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (explorer)");
        minterExplorerApi.mApiService.addHeader("X-Minter-Client-Version", "0.6.3");
        minterExplorerApi.mApiService.setDateFormat(DATE_FORMAT);
        minterExplorerApi.mGateApiService = new ApiService.Builder(string2, this.getGsonBuilder());
        minterExplorerApi.mGateApiService.addHeader("Content-Type", "application/json");
        minterExplorerApi.mGateApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (gate)");
        minterExplorerApi.mGateApiService.addHeader("X-Minter-Client-Version", "0.6.3");
        minterExplorerApi.mGateApiService.setDateFormat(DATE_FORMAT);
    }

    public static void initialize() {
        MinterExplorerApi.initialize(false);
    }

    public static void initialize(String string, String string2) {
        MinterExplorerApi.initialize(string, string2, false);
    }

    public static void initialize(String string, String string2, boolean bl, Mint.Leaf leaf) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterExplorerApi(string, string2);
        MinterExplorerApi.INSTANCE.mApiService.setDebug(bl);
        MinterExplorerApi.INSTANCE.mGateApiService.setDebug(bl);
        if (bl) {
            boolean bl2;
            block8: {
                bl2 = true;
                try {
                    Class.forName("android.util.Log");
                }
                catch (ClassNotFoundException classNotFoundException) {}
                try {
                    Log.d((String)"test", (String)"test");
                    break block8;
                }
                catch (RuntimeException runtimeException) {}
                {
                }
                bl2 = false;
            }
            if (!bl2 && leaf instanceof TimberLogger) {
                Mint.brew((Mint.Leaf)new StdLogger());
            } else {
                Mint.brew((Mint.Leaf)leaf);
            }
            MinterExplorerApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
            MinterExplorerApi.INSTANCE.mGateApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(String string, String string2, boolean bl) {
        MinterExplorerApi.initialize(string, string2, bl, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(boolean bl) {
        TimberLogger timberLogger;
        TimberLogger timberLogger2 = timberLogger;
        timberLogger = new TimberLogger();
        MinterExplorerApi.initialize(BASE_API_URL, BASE_GATE_URL, bl, (Mint.Leaf)timberLogger2);
    }

    public static void initialize(boolean bl, Mint.Leaf leaf) {
        MinterExplorerApi.initialize(BASE_API_URL, BASE_GATE_URL, bl, leaf);
    }

    public static HttpUrl.Builder newFrontUrl() {
        return HttpUrl.parse((String)FRONT_URL).newBuilder();
    }

    public static MinterExplorerApi getInstance() {
        return INSTANCE;
    }

    static {
        String string = "yyyy-MM-dd HH:mm:ssX";
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT < 24) {
                string = "yyyy-MM-dd HH:mm:ssZ";
            }
        }
        catch (Throwable throwable) {
            DATE_FORMAT = string;
            throw throwable;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        DATE_FORMAT = string;
    }

    public void setNetworkId(String string) {
        this.mApiService.addHeader("X-Minter-Chain-Id", string);
    }

    public GateGasRepository gas() {
        if (this.mGasRepository == null) {
            this.mGasRepository = new GateGasRepository(this.mGateApiService);
        }
        return this.mGasRepository;
    }

    public GateTransactionRepository transactionsGate() {
        if (this.mGateTxRepo == null) {
            this.mGateTxRepo = new GateTransactionRepository(this.mGateApiService);
        }
        return this.mGateTxRepo;
    }

    public GateEstimateRepository estimate() {
        if (this.mGateEstimateRepo == null) {
            this.mGateEstimateRepo = new GateEstimateRepository(this.mGateApiService);
        }
        return this.mGateEstimateRepo;
    }

    public ExplorerTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new ExplorerTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public ExplorerCoinsRepository coins() {
        if (this.mCoinsRepository == null) {
            this.mCoinsRepository = new ExplorerCoinsRepository(this.mApiService);
        }
        return this.mCoinsRepository;
    }

    public ExplorerValidatorsRepository validators() {
        if (this.mValidatorsRepository == null) {
            this.mValidatorsRepository = new ExplorerValidatorsRepository(this.mApiService);
        }
        return this.mValidatorsRepository;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public ApiService.Builder getGateApiService() {
        return this.mGateApiService;
    }

    public ExplorerAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ExplorerAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public GsonBuilder getGsonBuilder() {
        BytesDataJsonConverter bytesDataJsonConverter;
        BigDecimalJsonConverter bigDecimalJsonConverter;
        BigIntegerJsonConverter bigIntegerJsonConverter;
        MinterCheckJsonConverter minterCheckJsonConverter;
        MinterHashJsonConverter minterHashJsonConverter;
        MinterPublicKeyJsonConverter minterPublicKeyJsonConverter;
        MinterAddressJsonConverter minterAddressJsonConverter;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setDateFormat(DATE_FORMAT);
        Object object = minterAddressJsonConverter;
        minterAddressJsonConverter = new MinterAddressJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, object);
        object = minterPublicKeyJsonConverter;
        minterPublicKeyJsonConverter = new MinterPublicKeyJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterPublicKey.class, object);
        object = minterHashJsonConverter;
        minterHashJsonConverter = new MinterHashJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterHash.class, object);
        object = minterCheckJsonConverter;
        minterCheckJsonConverter = new MinterCheckJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterCheck.class, object);
        object = bigIntegerJsonConverter;
        bigIntegerJsonConverter = new BigIntegerJsonConverter();
        gsonBuilder.registerTypeAdapter(BigInteger.class, object);
        object = bigDecimalJsonConverter;
        bigDecimalJsonConverter = new BigDecimalJsonConverter(null);
        gsonBuilder.registerTypeAdapter(BigDecimal.class, object);
        object = bytesDataJsonConverter;
        bytesDataJsonConverter = new BytesDataJsonConverter();
        gsonBuilder.registerTypeAdapter(BytesData.class, object);
        return gsonBuilder;
    }

    private static final class BigDecimalJsonConverter
    implements JsonDeserializer<BigDecimal>,
    JsonSerializer<BigDecimal> {
        private BigDecimalJsonConverter() {
        }

        /* synthetic */ BigDecimalJsonConverter(1 var1_1) {
        }

        public BigDecimal deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
                if (jsonElement.getAsString().isEmpty()) {
                    return new BigDecimal("0").setScale(Transaction.VALUE_MUL_DEC.scale());
                }
                return new BigDecimal(jsonElement.getAsString());
            }
            return new BigDecimal("0");
        }

        public JsonElement serialize(BigDecimal bigDecimal, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(bigDecimal.toPlainString());
        }
    }
}

