/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.annimon.stream.Objects;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;
import org.parceler.Transient;

@Parcel
public class HistoryTransaction
implements Serializable,
Comparable<HistoryTransaction> {
    public BigInteger txn;
    public MinterHash hash;
    public BigInteger nonce;
    public BigInteger block;
    public Date timestamp;
    public BigDecimal fee;
    public Type type;
    public MinterAddress from;
    @Transient
    public Object data;
    public String payload;
    @Deprecated
    public transient String username;
    @Deprecated
    public transient String avatarUrl;

    public Type getType() {
        return this.type;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigInteger getBlock() {
        return this.block;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getTxNumber() {
        return this.txn;
    }

    public String getPayload() {
        return this.payload;
    }

    @Deprecated
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public MinterHash getHash() {
        return this.hash;
    }

    public MinterAddress getFrom() {
        return this.from;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isIncoming(List<MinterAddress> list) {
        if (this.type != Type.Send) {
            return false;
        }
        return list.contains(((TxSendCoinResult)this.getData()).to);
    }

    public <T> T getData() {
        return (T)this.data;
    }

    @Deprecated
    public String getAvatar() {
        return this.avatarUrl;
    }

    @Deprecated
    public HistoryTransaction setAvatar(String string) {
        this.avatarUrl = string;
        return this;
    }

    @Deprecated
    public HistoryTransaction setUsername(String string) {
        this.username = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && HistoryTransaction.class == object.getClass()) {
            object = (HistoryTransaction)object;
            return this.block.equals(((HistoryTransaction)object).block) && Objects.equals((Object)this.fee, (Object)((HistoryTransaction)object).fee) && Objects.equals((Object)this.hash, (Object)((HistoryTransaction)object).hash) && Objects.equals((Object)this.nonce, (Object)((HistoryTransaction)object).nonce) && Objects.equals((Object)this.timestamp, (Object)((HistoryTransaction)object).timestamp) && Objects.equals((Object)((Object)this.type), (Object)((Object)((HistoryTransaction)object).type)) && Objects.equals((Object)this.data, (Object)((HistoryTransaction)object).data);
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hash;
        objectArray2[1] = this.nonce;
        objectArray2[2] = this.block;
        objectArray2[3] = this.timestamp;
        objectArray2[4] = this.fee;
        objectArray2[5] = this.type;
        objectArray[6] = this.data;
        return Objects.hash((Object[])objectArray);
    }

    @Override
    public int compareTo(@Nonnull HistoryTransaction historyTransaction) {
        return historyTransaction.timestamp.compareTo(this.timestamp);
    }

    public static enum Type {
        Send(TxSendCoinResult.class),
        SellCoin(TxConvertCoinResult.class),
        SellAllCoins(TxConvertCoinResult.class),
        BuyCoin(TxConvertCoinResult.class),
        CreateCoin(TxCreateResult.class),
        DeclareCandidacy(TxDeclareCandidacyResult.class),
        Delegate(TxDelegateUnbondResult.class),
        Unbond(TxDelegateUnbondResult.class),
        RedeemCheck(TxRedeemCheckResult.class),
        SetCandidateOnline(TxSetCandidateOnlineOfflineResult.class),
        SetCandidateOffline(TxSetCandidateOnlineOfflineResult.class),
        CreateMultisigAddress(TxCreateMultisigResult.class),
        MultiSend(TxMultisendResult.class),
        EditCandidate(TxEditCandidateResult.class);

        Class<?> mCls;

        private Type(Class<?> clazz) {
            this.mCls = clazz;
        }

        public Class<?> getCls() {
            return this.mCls;
        }
    }

    @Parcel
    public static class TxSendCoinResult {
        public MinterAddress to;
        public String coin;
        @SerializedName(value="value")
        public BigDecimal amount;

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            String string = ((TxSendCoinResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    @Deprecated
    @Parcel
    public static class CandidateEditResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
    }

    @Parcel
    public static class TxEditCandidateResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;

        public MinterPublicKey getPublicKey() {
            return this.pubKey;
        }

        public MinterAddress getRewardAddress() {
            return this.rewardAddress;
        }

        public MinterAddress getOwnerAddress() {
            return this.ownerAddress;
        }
    }

    @Parcel
    public static class TxMultisendResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;
    }

    @Parcel
    public static class TxCreateMultisigResult {
        public BigInteger threshold;
        public List<BigInteger> weights = new ArrayList<BigInteger>();
        public List<MinterAddress> addresses = new ArrayList<MinterAddress>();
    }

    @Parcel
    public static class CheckData {
        public String coin;
        public String nonce;
        public BigDecimal value;
        public MinterAddress sender;
        @SerializedName(value="due_block")
        public BigInteger dueBlock;

        public String getCoin() {
            return this.coin;
        }

        public String getNonce() {
            return this.nonce;
        }

        public MinterAddress getSender() {
            return this.sender;
        }

        public BigInteger getDueBlock() {
            return this.dueBlock;
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }

    @Parcel
    public static class TxRedeemCheckResult {
        @SerializedName(value="raw_check")
        public String rawCheck;
        public String proof;
        @Deprecated
        public CheckData check;

        public String getRawProof() {
            return this.proof;
        }

        @Deprecated
        public CheckData getCheck() {
            return this.check;
        }

        public String getRawCheck() {
            return this.rawCheck;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String stake;
        public String value;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public BigDecimal getStake() {
            String string = this.stake;
            if (string == null || string.isEmpty()) {
                this.stake = "0";
            }
            return new BigDecimal(this.stake);
        }

        public BigDecimal getValue() {
            String string = this.value;
            if (string == null || string.isEmpty()) {
                this.value = "0";
            }
            return new BigDecimal(this.value);
        }

        public String getCoin() {
            String string = ((TxDelegateUnbondResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public String coin;
        public BigDecimal stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            String string = ((TxDeclareCandidacyResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigDecimal.ZERO;
            }
            return this.stake;
        }
    }

    @Parcel
    public static class TxConvertCoinResult {
        @SerializedName(value="coin_to_sell")
        public String coinToSell;
        @SerializedName(value="coin_to_buy")
        public String coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigDecimal valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigDecimal valueToSell;
        @SerializedName(value="maximum_value_to_sell")
        public BigDecimal maxValueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigDecimal minValueToBuy;

        public BigDecimal getMinValueToBuy() {
            return this.minValueToBuy;
        }

        public BigDecimal getMaxValueToSell() {
            return this.maxValueToSell;
        }

        public String getCoinToSell() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToSell;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public String getCoinToBuy() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToBuy;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigDecimal.ZERO;
            }
            return this.valueToBuy;
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigDecimal.ZERO;
            }
            return this.valueToSell;
        }
    }

    @Parcel
    public static class TxCreateResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigDecimal initialAmount;
        @SerializedName(value="initial_reserve")
        public BigDecimal initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public int constantReserveRatio;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return this.initialAmount;
        }

        public BigDecimal getInitialReserve() {
            return this.initialReserve;
        }

        public int getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    public static class TxDefaultResult {
    }

    public static enum Status {
        Success,
        Error;

    }
}

