/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import org.parceler.Parcel;

@Parcel
public class AddressData {
    public Map<String, CoinBalance> coins;
    public MinterAddress address;
    public BigDecimal totalBalanceInBase;
    public BigDecimal totalBalanceInUSD;

    public AddressData() {
        this.totalBalanceInUSD = this.totalBalanceInBase = BigDecimal.ZERO;
        this.coins = new HashMap<String, CoinBalance>();
    }

    public Map<String, CoinBalance> getCoins() {
        if (this.coins == null) {
            this.coins = new HashMap<String, CoinBalance>();
        }
        return this.coins;
    }

    public void fillDefaultsOnEmpty() {
        if (((AddressData)((Object)coinBalance2)).getCoins().isEmpty()) {
            CoinBalance coinBalance;
            CoinBalance coinBalance2 = coinBalance;
            coinBalance = new CoinBalance("MNT", BigDecimal.ZERO);
            ((AddressData)((Object)coinBalance2)).coins.put("MNT", coinBalance2);
        }
    }

    public BigDecimal getAvailableBalanceBIP() {
        if (!this.coins.containsKey("MNT")) {
            return BigDecimal.ZERO;
        }
        return ((CoinBalance)MoreObjects.firstNonNull((Object)this.coins.get("MNT"), (Object)new CoinBalance("MNT", BigDecimal.ZERO))).getAmount();
    }

    public BigDecimal getTotalBalance() {
        return this.totalBalanceInBase;
    }

    public BigDecimal getTotalBalanceUSD() {
        return this.totalBalanceInUSD;
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigDecimal amount;

        public CoinBalance() {
        }

        public CoinBalance(String string, BigDecimal bigDecimal) {
            this.coin = string;
            this.amount = bigDecimal;
        }

        public String getCoin() {
            String string = ((CoinBalance)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return (BigDecimal)MoreObjects.firstNonNull((Object)this.amount, (Object)BigDecimal.ZERO);
        }
    }
}

