/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerTransactionEndpoint;
import network.minter.explorer.api.converters.ExplorerHistoryTransactionDeserializer;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.HistoryTransaction;
import network.minter.explorer.repo.TxSearchQuery;
import retrofit2.Call;

public class ExplorerTransactionRepository
extends DataRepository<ExplorerTransactionEndpoint>
implements DataRepository.Configurator {
    public ExplorerTransactionRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(TxSearchQuery txSearchQuery) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(txSearchQuery.build());
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress minterAddress) {
        HashMap hashMap;
        Preconditions.checkArgument((minterAddress != null ? 1 : 0) != 0, (Object)"Address can't be null");
        ExplorerTransactionRepository explorerTransactionRepository = object;
        Object object = hashMap;
        ((HashMap)object)();
        hashMap.put("address", minterAddress.toString());
        return ((ExplorerTransactionEndpoint)explorerTransactionRepository.getInstantService()).getTransactions((Map<String, Object>)object);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> list) {
        return this.getTransactions(list, 1L);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> object, long l) {
        ArrayList<String> arrayList;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(arrayList2, l);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> object, long l, int n) {
        ArrayList<String> arrayList;
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((MinterAddress)object.next()).toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(arrayList2, l, n);
    }

    public void configure(ApiService.Builder builder) {
        ExplorerHistoryTransactionDeserializer explorerHistoryTransactionDeserializer;
        Object object = explorerHistoryTransactionDeserializer;
        explorerHistoryTransactionDeserializer = new ExplorerHistoryTransactionDeserializer();
        builder.registerTypeAdapter(HistoryTransaction.class, object);
    }

    @Nonnull
    protected Class<ExplorerTransactionEndpoint> getServiceClass() {
        return ExplorerTransactionEndpoint.class;
    }
}

