/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;

public final class TxSearchQuery {
    private long mBlock = -1L;
    private long mPage = -1L;
    private long mPerPage = -1L;
    private List<MinterAddress> mAddressList = new ArrayList<MinterAddress>(0);
    private List<MinterHash> mHashList = new ArrayList<MinterHash>(0);
    private List<MinterPublicKey> mPubKeyList = new ArrayList<MinterPublicKey>(0);

    public TxSearchQuery setBlock(long block) {
        this.mBlock = block;
        return this;
    }

    public TxSearchQuery addAddress(MinterAddress address) {
        this.mAddressList.add(address);
        return this;
    }

    public TxSearchQuery addAddress(String address) {
        this.mAddressList.add(new MinterAddress((CharSequence)address));
        return this;
    }

    public TxSearchQuery addHash(MinterHash hash) {
        this.mHashList.add(hash);
        return this;
    }

    public TxSearchQuery addHash(String hash) {
        this.mHashList.add(new MinterHash((CharSequence)hash));
        return this;
    }

    public TxSearchQuery addPublicKey(MinterPublicKey pubKey) {
        this.mPubKeyList.add(pubKey);
        return this;
    }

    public TxSearchQuery addPublicKey(String pubKey) {
        this.mPubKeyList.add(new MinterPublicKey((CharSequence)pubKey));
        return this;
    }

    public TxSearchQuery setPage(long pageNum) {
        this.mPage = pageNum;
        return this;
    }

    public TxSearchQuery setLimit(long limit) {
        this.mPerPage = limit;
        return this;
    }

    Map<String, Object> build() {
        int i;
        HashMap<String, Object> out = new HashMap<String, Object>();
        if (this.mBlock >= 0L) {
            out.put("block", String.valueOf(this.mBlock));
        }
        if (this.mPage >= 0L) {
            out.put("page", this.mPage);
        }
        if (this.mPerPage >= 0L) {
            out.put("perPage", this.mPerPage);
        }
        if (!this.mAddressList.isEmpty()) {
            if (this.mAddressList.size() == 1) {
                out.put("address", this.mAddressList.get(0).toString());
            } else {
                i = 0;
                for (MinterAddress address : this.mAddressList) {
                    out.put("addresses[" + i + "]", address.toString());
                    ++i;
                }
            }
        }
        if (!this.mHashList.isEmpty()) {
            if (this.mHashList.size() == 1) {
                out.put("hash", this.mHashList.get(0).toString());
            } else {
                i = 0;
                for (MinterHash hash : this.mHashList) {
                    out.put("hashes[" + i + "]", hash.toString());
                    ++i;
                }
            }
        }
        if (!this.mPubKeyList.isEmpty()) {
            if (this.mPubKeyList.size() == 1) {
                out.put("pubKey", this.mPubKeyList.get(0).toString());
            } else {
                i = 0;
                for (MinterPublicKey pk : this.mPubKeyList) {
                    out.put("pubKeys[" + i + "]", pk.toString());
                    ++i;
                }
            }
        }
        return out;
    }
}

