/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerTransactionEndpoint;
import network.minter.explorer.api.converters.ExplorerHistoryTransactionDeserializer;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.HistoryTransaction;
import network.minter.explorer.repo.TxSearchQuery;
import retrofit2.Call;

public class ExplorerTransactionRepository
extends DataRepository<ExplorerTransactionEndpoint>
implements DataRepository.Configurator {
    public ExplorerTransactionRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(TxSearchQuery builder) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(builder.build());
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address can't be null");
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("address", address.toString());
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(query);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses) {
        return this.getTransactions(addresses, 1L);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses, long page) {
        Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((addresses.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(out, page);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses, long page, int limit) {
        Preconditions.checkArgument((addresses != null ? 1 : 0) != 0, (Object)"Address list can't be null");
        Preconditions.checkArgument((addresses.size() > 0 ? 1 : 0) != 0, (Object)"Address list can't be empty");
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(out, page, limit);
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(HistoryTransaction.class, (Object)new ExplorerHistoryTransactionDeserializer());
    }

    @Nonnull
    protected Class<ExplorerTransactionEndpoint> getServiceClass() {
        return ExplorerTransactionEndpoint.class;
    }
}

