/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerCoinsEndpoint;
import network.minter.explorer.models.BCExplorerResult;
import network.minter.explorer.models.CoinItem;
import network.minter.explorer.models.ExpResult;
import retrofit2.Call;

public class ExplorerCoinsRepository
extends DataRepository<ExplorerCoinsEndpoint> {
    public ExplorerCoinsRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<List<CoinItem>>> getAll() {
        return ((ExplorerCoinsEndpoint)this.getInstantService()).getAll();
    }

    public Call<BCExplorerResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigDecimal valueToSell, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToSell(coinToSell, valueToSell.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<BCExplorerResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigInteger valueToSell, @Nonnull String coinToBuy) {
        return ((ExplorerCoinsEndpoint)this.getInstantService()).getCoinExchangeCurrencyToSell(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToSell.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    public Call<BCExplorerResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigDecimal valueToBuy, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToBuy(coinToSell, valueToBuy.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<BCExplorerResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigInteger valueToBuy, @Nonnull String coinToBuy) {
        return ((ExplorerCoinsEndpoint)this.getInstantService()).getCoinExchangeCurrencyToBuy(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToBuy.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    public Call<ExpResult<List<CoinItem>>> search(String symbol) {
        return ((ExplorerCoinsEndpoint)this.getInstantService()).search(symbol);
    }

    @Nonnull
    protected Class<ExplorerCoinsEndpoint> getServiceClass() {
        return ExplorerCoinsEndpoint.class;
    }
}

