/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.CountableData;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.TransactionSendResult;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.helpers.CollectionsHelper;
import network.minter.explorer.api.ExplorerTransactionEndpoint;
import network.minter.explorer.api.converters.ExplorerHistoryTransactionDeserializer;
import network.minter.explorer.models.BCExplorerResult;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.HistoryTransaction;
import retrofit2.Call;

public class ExplorerTransactionRepository
extends DataRepository<ExplorerTransactionEndpoint>
implements DataRepository.Configurator {
    public ExplorerTransactionRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress address) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("address", address.toString());
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(query);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses) {
        return this.getTransactions(addresses, 1L);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses, long page) {
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(out, page);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses, long page, int limit) {
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(out, page, limit);
    }

    public Call<BCExplorerResult<CountableData>> getTransactionCount(@Nonnull MinterAddress key) {
        Preconditions.checkNotNull((Object)key, (String)"Public key required!");
        return this.getTransactionCount(key.toString());
    }

    public Call<BCExplorerResult<CountableData>> getTransactionCount(@Nonnull String address) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactionsCount((String)Preconditions.checkNotNull((Object)address, (String)"Address required!"));
    }

    public Call<BCExplorerResult<TransactionSendResult>> sendTransaction(@Nonnull TransactionSign transactionSign) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).sendTransaction(CollectionsHelper.asMap((Object[])new String[]{"transaction", transactionSign.getTxSign()}));
    }

    public Call<BCExplorerResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign sign) {
        return this.getTransactionCommission(sign.getTxSign());
    }

    public Call<BCExplorerResult<TransactionCommissionValue>> getTransactionCommission(String sign) {
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTxCommission(sign);
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(HistoryTransaction.class, (Object)new ExplorerHistoryTransactionDeserializer());
    }

    @Nonnull
    protected Class<ExplorerTransactionEndpoint> getServiceClass() {
        return ExplorerTransactionEndpoint.class;
    }
}

