/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.repo;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.explorer.api.ExplorerTransactionEndpoint;
import network.minter.explorer.api.converters.ExplorerHistoryTransactionDeserializer;
import network.minter.explorer.models.ExpResult;
import network.minter.explorer.models.HistoryTransaction;
import retrofit2.Call;

public class ExplorerTransactionRepository
extends DataRepository<ExplorerTransactionEndpoint>
implements DataRepository.Configurator {
    public ExplorerTransactionRepository(@NonNull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(MinterAddress address) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("address", address.toString());
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(query);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses) {
        return this.getTransactions(addresses, 1L);
    }

    public Call<ExpResult<List<HistoryTransaction>>> getTransactions(List<MinterAddress> addresses, long page) {
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return ((ExplorerTransactionEndpoint)this.getInstantService()).getTransactions(out, page);
    }

    @NonNull
    protected Class<ExplorerTransactionEndpoint> getServiceClass() {
        return ExplorerTransactionEndpoint.class;
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(HistoryTransaction.class, (Object)new ExplorerHistoryTransactionDeserializer());
    }
}

