/*
 * Decompiled with CFR 0.152.
 */
package network.minter.explorer.models;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import network.minter.core.crypto.MinterAddress;
import org.parceler.Parcel;

@Parcel
public class AddressData {
    public Map<String, CoinBalance> coins = new HashMap<String, CoinBalance>();
    public long txCount;
    public MinterAddress address;

    public void fillDefaultsOnEmpty() {
        if (this.coins == null) {
            this.coins = new HashMap<String, CoinBalance>(1);
        }
        if (this.coins.isEmpty()) {
            this.coins.put("MNT", new CoinBalance("MNT", new BigDecimal(0), new BigDecimal(0)));
        }
    }

    public BigDecimal getTotalBalance() {
        if (this.coins == null || this.coins.isEmpty()) {
            return new BigDecimal(0);
        }
        BigDecimal totalOut = new BigDecimal(0.0);
        for (Map.Entry<String, CoinBalance> entry : this.coins.entrySet()) {
            totalOut = totalOut.add(entry.getValue().amount);
        }
        return totalOut;
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigDecimal amount;
        public BigDecimal usdAmount;
        public BigDecimal baseCoinAmount;

        public CoinBalance() {
        }

        public CoinBalance(String coin, BigDecimal value, BigDecimal valueUsd) {
            this.coin = coin;
            this.amount = value;
            this.usdAmount = valueUsd;
        }

        public String getCoin() {
            return this.coin;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getUsdAmount() {
            return this.usdAmount;
        }
    }
}

