/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.BuildConfig;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.blockchain.models.operational.SignatureMultiData;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxCreateMultisigAddress;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxEditCandidateTransaction;
import network.minter.blockchain.models.operational.TxMultisend;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.crypto.UnsignedBytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.internal.log.Mint;
import network.minter.core.util.RLPBoxed;

public class Transaction
implements Parcelable {
    public static final BigInteger VALUE_MUL = new BigInteger("1000000000000000000", 10);
    public static final BigDecimal VALUE_MUL_DEC = new BigDecimal("1000000000000000000");
    public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

        public Transaction createFromParcel(Parcel parcel) {
            return new Transaction(parcel);
        }

        public Transaction[] newArray(int n) {
            return new Transaction[n];
        }
    };
    private BigInteger mNonce;
    private BlockchainID mChainId;
    private BigInteger mGasPrice = new BigInteger("1");
    private String mGasCoin = "MNT";
    private OperationType mType = OperationType.SendCoin;
    private Operation mOperationData;
    private UnsignedBytesData mPayload = new UnsignedBytesData(new char[0]);
    private UnsignedBytesData mServiceData = new UnsignedBytesData(new char[0]);
    private SignatureType mSignatureType = SignatureType.Single;
    private SignatureData mSignatureData;

    protected Transaction(BigInteger bigInteger) {
        this.mNonce = bigInteger;
    }

    protected Transaction() {
    }

    protected Transaction(Parcel parcel) {
        this.mNonce = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mChainId = (BlockchainID)((Object)parcel.readValue(BlockchainID.class.getClassLoader()));
        this.mGasPrice = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mGasCoin = parcel.readString();
        this.mType = (OperationType)((Object)parcel.readValue(OperationType.class.getClassLoader()));
        this.mOperationData = (Operation)parcel.readValue(Operation.class.getClassLoader());
        this.mPayload = (UnsignedBytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mServiceData = (UnsignedBytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mSignatureType = (SignatureType)((Object)parcel.readValue(SignatureType.class.getClassLoader()));
        this.mSignatureData = (SignatureData)parcel.readValue(this.mSignatureType.mTypeClass.getClassLoader());
    }

    public static Transaction fromEncoded(@Nonnull String objectArray) {
        Transaction transaction;
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new UnsignedBytesData((CharSequence)objectArray).getData(), (int)0).getDecoded();
        Transaction transaction2 = transaction;
        transaction2();
        transaction.decodeRLP(objectArray);
        Object var2_6 = null;
        Class<? extends Operation> clazz = transaction.mType.getOpClass();
        Class[] classArray = new Class[1];
        classArray[0] = Transaction.class;
        Constructor<? extends Operation> constructor = clazz.getDeclaredConstructor(classArray);
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = transaction2;
        Operation operation = transaction.mOperationData = constructor.newInstance(objectArray2);
        operation.decodeRLP(transaction2.fromRawRlp(5, objectArray));
        SignatureData signatureData = transaction.mSignatureData = transaction.mSignatureType.getSignClass().newInstance();
        try {
            signatureData.decodeRLP(transaction2.fromRawRlp(9, objectArray));
            objectArray = var2_6;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (objectArray != null) {
            Mint.e((Throwable)objectArray, (String)"Unable to decode transaction", (Object[])new Object[0]);
            return null;
        }
        return transaction2;
    }

    static /* synthetic */ BlockchainID access$002(Transaction transaction, BlockchainID blockchainID) {
        transaction.mChainId = blockchainID;
        return blockchainID;
    }

    static /* synthetic */ String access$102(Transaction transaction, String string) {
        transaction.mGasCoin = string;
        return string;
    }

    static /* synthetic */ BigInteger access$202(Transaction transaction, BigInteger bigInteger) {
        transaction.mGasPrice = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ UnsignedBytesData access$302(Transaction transaction, UnsignedBytesData unsignedBytesData) {
        transaction.mPayload = unsignedBytesData;
        return unsignedBytesData;
    }

    static /* synthetic */ BigInteger access$402(Transaction transaction, BigInteger bigInteger) {
        transaction.mNonce = bigInteger;
        return bigInteger;
    }

    public void cleanup() {
        Transaction transaction = this;
        transaction.mNonce = null;
        transaction.mChainId = null;
        transaction.mGasPrice = null;
        transaction.mGasCoin = null;
        transaction.mType = null;
        transaction.mOperationData = null;
        transaction.mPayload = null;
        transaction.mServiceData = null;
        transaction.mSignatureType = null;
        transaction.mSignatureData = null;
    }

    public SignatureType getSignatureType() {
        return this.mSignatureType;
    }

    public <SignData extends SignatureData> SignData getSignatureData(Class<SignData> clazz) {
        return (SignData)((SignatureData)clazz.cast(this.mSignatureData));
    }

    public <SignData extends SignatureData> SignData getSignatureData() {
        return (SignData)this.mSignatureData;
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getGasPrice() {
        return this.mGasPrice;
    }

    public OperationType getType() {
        return this.mType;
    }

    @Deprecated
    public TransactionSign sign(@Nonnull PrivateKey privateKey) {
        return this.signSingle(privateKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransactionSign signMulti(MinterAddress minterAddress, @Nonnull List<PrivateKey> iterator) {
        ArrayList<SignatureSingleData> arrayList;
        this.mSignatureType = SignatureType.Multi;
        Preconditions.checkArgument((iterator.size() > 0 ? 1 : 0) != 0, (Object)"Private keys can't be empty");
        UnsignedBytesData unsignedBytesData = new UnsignedBytesData(this.encode(true)).sha3Data();
        ArrayList<SignatureSingleData> arrayList2 = arrayList;
        arrayList = new ArrayList<SignatureSingleData>(iterator.size());
        long l = NativeSecp256k1.contextCreate();
        try {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                PrivateKey privateKey = (PrivateKey)iterator.next();
                privateKey = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])BytesHelper.charsToBytes((char[])unsignedBytesData.getData()), (byte[])privateKey.getData());
                SignatureSingleData signatureSingleData = new SignatureSingleData();
                signatureSingleData.setSign((NativeSecp256k1.RecoverableSignature)privateKey);
                arrayList2.add(signatureSingleData);
            }
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        this.mSignatureData = new SignatureMultiData();
        ((SignatureMultiData)this.mSignatureData).setSigns(minterAddress, arrayList2);
        return new TransactionSign(new UnsignedBytesData(this.encode(false)).toHexString());
    }

    public TransactionSign signSingle(@Nonnull PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        this.mSignatureType = SignatureType.Single;
        Object object = this.encode(true);
        object = new UnsignedBytesData(object).sha3Data();
        long l = NativeSecp256k1.contextCreate();
        try {
            privateKey = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])BytesHelper.charsToBytes((char[])object.getData()), (byte[])privateKey.getData());
            recoverableSignature = privateKey;
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        if (recoverableSignature == null) {
            return null;
        }
        this.mSignatureData = new SignatureSingleData();
        ((SignatureSingleData)this.mSignatureData).setSign((NativeSecp256k1.RecoverableSignature)privateKey);
        return new TransactionSign(new UnsignedBytesData(this.encode(false)).toHexString());
    }

    public <OpType extends Operation> OpType getData(Class<OpType> clazz) {
        return (OpType)((Operation)clazz.cast(this.mOperationData));
    }

    public <OpType extends Operation> OpType getData() {
        return (OpType)this.mOperationData;
    }

    <Op extends Operation> Transaction setData(Op Op) {
        this.mOperationData = Op;
        this.mType = Op.getType();
        return this;
    }

    public String getGasCoin() {
        return this.mGasCoin.replace("\u0000", "");
    }

    public UnsignedBytesData getPayload() {
        return this.mPayload;
    }

    public String getPayloadString() {
        return new String(this.getPayload().getData());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mNonce);
        parcel.writeValue((Object)this.mChainId);
        parcel.writeValue((Object)this.mGasPrice);
        parcel.writeString(this.mGasCoin);
        parcel.writeValue((Object)this.mType);
        parcel.writeValue((Object)this.mOperationData);
        parcel.writeValue((Object)this.mPayload);
        parcel.writeValue((Object)this.mServiceData);
        parcel.writeValue((Object)this.mSignatureType);
        parcel.writeValue((Object)this.mSignatureType);
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    void decodeRLP(Object[] objectArray) {
        this.mNonce = BytesHelper.fixBigintSignedByte((Object)objectArray[0]);
        this.mChainId = BlockchainID.valueOf(BytesHelper.fixBigintSignedByte((char[])this.fromRawRlp(1, objectArray)));
        this.mGasPrice = BytesHelper.fixBigintSignedByte((Object)objectArray[2]);
        this.mGasCoin = StringHelper.charsToString((char[])this.fromRawRlp(3, objectArray), (int)10);
        this.mType = OperationType.findByValue(new BigInteger(BytesHelper.charsToBytes((char[])this.fromRawRlp(4, objectArray))));
        this.mPayload = new UnsignedBytesData(this.fromRawRlp(6, objectArray));
        this.mServiceData = new UnsignedBytesData(this.fromRawRlp(7, objectArray));
        this.mSignatureType = SignatureType.findByValue(new BigInteger(BytesHelper.charsToBytes((char[])this.fromRawRlp(8, objectArray))));
    }

    char[] encode(boolean bl) {
        char[] cArray = this.mOperationData.encodeRLP();
        if (bl) {
            Object[] objectArray = new Object[9];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray2[2] = this.mGasPrice;
            objectArray2[3] = this.mGasCoin;
            objectArray2[4] = this.mOperationData.getType().getValue();
            objectArray2[5] = cArray;
            objectArray2[6] = this.mPayload.getData();
            objectArray2[7] = this.mServiceData.getData();
            objectArray[8] = this.mSignatureType.getValue();
            return RLPBoxed.encode((Object)objectArray);
        }
        char[] cArray2 = this.mSignatureData.encodeRLP();
        Object[] objectArray = new Object[10];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = this.mNonce.toByteArray();
        objectArray3[1] = BigInteger.valueOf(this.mChainId.getId());
        objectArray3[2] = this.mGasPrice;
        objectArray3[3] = this.mGasCoin;
        objectArray3[4] = this.mOperationData.getType().getValue();
        objectArray3[5] = cArray;
        objectArray3[6] = this.mPayload.getData();
        objectArray3[7] = this.mServiceData.getData();
        objectArray[8] = this.mSignatureType.getValue();
        objectArray[9] = cArray2;
        return RLPBoxed.encode((Object)objectArray);
    }

    FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult("Invalid transaction data");
        String string = "nonce";
        boolean bl = ((Transaction)((Object)fieldsValidationResult2)).mNonce != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Nonce must be set");
        string = "gasPrice";
        bl = ((Transaction)((Object)fieldsValidationResult2)).mGasCoin != null;
        Transaction transaction = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Gas coin must be set");
        object = "operationData";
        boolean bl2 = transaction.mOperationData != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Operation data does not set! Check your operation model.");
    }

    public static class Builder {
        private final Transaction mTx;

        public Builder(BigInteger bigInteger) {
            Builder builder = this;
            builder.mTx = new Transaction(bigInteger);
            Transaction.access$002(builder.mTx, BuildConfig.BLOCKCHAIN_ID);
        }

        public Builder setBlockchainId(BlockchainID blockchainID) {
            Builder builder = this;
            Transaction.access$002(builder.mTx, blockchainID);
            return builder;
        }

        public Builder setGasCoin(String string) {
            Builder builder = this;
            Transaction.access$102(builder.mTx, StringHelper.strrpad((int)10, (String)string));
            return builder;
        }

        public Builder setGasPrice(BigInteger bigInteger) {
            Builder builder = this;
            Transaction.access$202(builder.mTx, bigInteger);
            return builder;
        }

        public Builder setPayload(byte[] byArray) {
            return this.setPayload(new BytesData(byArray, true));
        }

        public Builder setPayload(BytesData bytesData) {
            Preconditions.checkArgument((bytesData.size() <= 1024 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes");
            Builder builder = this;
            Transaction.access$302(builder.mTx, new UnsignedBytesData(bytesData.getData(), true));
            return builder;
        }

        public Builder setPayload(@Nonnull String string) {
            String string2 = string;
            Preconditions.checkNotNull((Object)string2, (String)"Hex data string can't be null");
            Preconditions.checkArgument((string2.length() <= 2048 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes (2048 in hex string)");
            Builder builder = this;
            Transaction.access$302(builder.mTx, new UnsignedBytesData((CharSequence)string));
            return builder;
        }

        public Builder setPayload(ByteBuffer byteBuffer) {
            return this.setPayload(byteBuffer.array());
        }

        public Builder setNonce(BigInteger bigInteger) {
            Builder builder = this;
            Transaction.access$402(builder.mTx, bigInteger);
            return builder;
        }

        public <Op extends Operation> Op create(Class<Op> clazz) {
            Class[] classArray = new Class[1];
            classArray[0] = Transaction.class;
            Constructor<Op> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = this.mTx;
                return (Op)((Operation)constructor.newInstance(objectArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
        }

        public TxCoinBuy buyCoin() {
            return new TxCoinBuy(this.mTx);
        }

        public TxCoinSell sellCoin() {
            return new TxCoinSell(this.mTx);
        }

        public TxCoinSellAll sellAllCoins() {
            return new TxCoinSellAll(this.mTx);
        }

        public TxCreateCoin createCoin() {
            return new TxCreateCoin(this.mTx);
        }

        public TxDeclareCandidacy declareCandidacy() {
            return new TxDeclareCandidacy(this.mTx);
        }

        public TxDelegate delegate() {
            return new TxDelegate(this.mTx);
        }

        public TxRedeemCheck redeemCheck() {
            return new TxRedeemCheck(this.mTx);
        }

        public TxSendCoin sendCoin() {
            return new TxSendCoin(this.mTx);
        }

        public TxCreateMultisigAddress createMultisigAddress() {
            return new TxCreateMultisigAddress(this.mTx);
        }

        public TxMultisend multiSend() {
            return new TxMultisend(this.mTx);
        }

        public TxEditCandidateTransaction editCandidate() {
            return new TxEditCandidateTransaction(this.mTx);
        }

        public TxSetCandidateOffline setCandidateOffline() {
            return new TxSetCandidateOffline(this.mTx);
        }

        public TxSetCandidateOnline setCandidateOnline() {
            return new TxSetCandidateOnline(this.mTx);
        }

        public TxUnbound unbound() {
            return new TxUnbound(this.mTx);
        }
    }

    public static enum SignatureType {
        Single(1, SignatureSingleData.class),
        Multi(2, SignatureMultiData.class);

        BigInteger mVal;
        Class<? extends SignatureData> mTypeClass;

        private SignatureType(byte by, Class<? extends SignatureData> clazz) {
            this.mVal = new BigInteger(String.valueOf(by));
            this.mTypeClass = clazz;
        }

        public static SignatureType findByValue(BigInteger bigInteger) {
            for (SignatureType signatureType : SignatureType.values()) {
                if (!signatureType.getValue().equals(bigInteger)) continue;
                return signatureType;
            }
            return null;
        }

        public BigInteger getValue() {
            return this.mVal;
        }

        public Class<? extends SignatureData> getSignClass() {
            return this.mTypeClass;
        }
    }
}

