/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.HashUtil;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;

public class CheckTransaction {
    private String mPassphrase;
    private BigInteger mNonce;
    private BigInteger mDueBlock;
    private String mCoin = "MNT";
    private BigInteger mValue;
    private BytesData mLock;
    private SignatureSingleData mSignature;

    CheckTransaction(BigInteger bigInteger, String string) {
        this.mNonce = bigInteger;
        this.mPassphrase = string;
    }

    public static BytesData makeProof(MinterAddress minterAddress, String object) {
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        BytesData bytesData;
        BytesData bytesData2 = bytesData;
        bytesData = new BytesData(HashUtil.sha256((byte[])((String)object).getBytes()));
        minterAddress = new BytesData(RLP.encode((Object)new Object[]{minterAddress.getData()})).sha3Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            minterAddress = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])minterAddress.getData(), (byte[])bytesData2.getData());
            recoverableSignature = minterAddress;
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        object = recoverableSignature.v;
        if (recoverableSignature.v[0] != 1) {
            object[0] = false;
        }
        byte[][] byArrayArray = new byte[3][];
        object = byArrayArray;
        object[0] = minterAddress.r;
        object[1] = minterAddress.s;
        byArrayArray[2] = minterAddress.v;
        return new BytesData((byte[][])byArrayArray);
    }

    private byte[] encode(boolean bl) {
        if (bl) {
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = this.mDueBlock;
            objectArray2[2] = this.mCoin;
            objectArray[3] = this.mValue;
            return RLP.encode((Object)objectArray);
        }
        CheckTransaction checkTransaction = this;
        byte[] byArray = checkTransaction.mLock.getData();
        Object[] objectArray = checkTransaction.mSignature;
        if (checkTransaction.mSignature != null && objectArray.getV() != null && this.mSignature.getR() != null && this.mSignature.getS() != null) {
            Object[] objectArray3 = new Object[8];
            objectArray = objectArray3;
            objectArray[0] = this.mNonce;
            objectArray[1] = this.mDueBlock;
            objectArray[2] = this.mCoin;
            objectArray[3] = this.mValue;
            objectArray[4] = byArray;
            objectArray[5] = this.mSignature.getV();
            objectArray[6] = this.mSignature.getR();
            objectArray3[7] = this.mSignature.getS();
            return RLP.encode((Object)objectArray3);
        }
        Object[] objectArray4 = new Object[5];
        objectArray = objectArray4;
        objectArray[0] = this.mNonce;
        objectArray[1] = this.mDueBlock;
        objectArray[2] = this.mCoin;
        objectArray4[3] = this.mValue;
        objectArray4[4] = byArray;
        return RLP.encode((Object)objectArray4);
    }

    static /* synthetic */ String access$002(CheckTransaction checkTransaction, String string) {
        checkTransaction.mCoin = string;
        return string;
    }

    static /* synthetic */ BigInteger access$102(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mValue = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$202(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mDueBlock = bigInteger;
        return bigInteger;
    }

    public void cleanup() {
        CheckTransaction checkTransaction = this;
        checkTransaction.mPassphrase = null;
        checkTransaction.mNonce = null;
        checkTransaction.mDueBlock = null;
        checkTransaction.mCoin = null;
        checkTransaction.mValue = null;
        checkTransaction.mLock = null;
        checkTransaction.mSignature = null;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getDueBlock() {
        return this.mDueBlock;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public SignatureSingleData getSignature() {
        return this.mSignature;
    }

    public TransactionSign sign(PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        BytesData bytesData = new BytesData(((CheckTransaction)((Object)string)).encode(true)).sha3Data();
        Object object = new BytesData(((CheckTransaction)((Object)string)).mPassphrase.getBytes()).sha256Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            bytesData = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])bytesData.getData(), (byte[])object.getData());
            recoverableSignature = bytesData;
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        object = recoverableSignature.v;
        if (recoverableSignature.v[0] != 1) {
            object[0] = (BytesData)false;
        }
        byte[][] byArrayArray = new byte[3][];
        object = byArrayArray;
        object[0] = (BytesData)bytesData.r;
        object[1] = (BytesData)bytesData.s;
        byArrayArray[2] = bytesData.v;
        ((CheckTransaction)((Object)string)).mLock = new BytesData((byte[][])byArrayArray);
        bytesData = new BytesData(((CheckTransaction)((Object)string)).encode(false)).sha3Mutable();
        long l2 = NativeSecp256k1.contextCreate();
        try {
            privateKey = NativeSecp256k1.signRecoverableSerialized((long)l2, (byte[])bytesData.getData(), (byte[])privateKey.getData());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l2);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l2);
        ((CheckTransaction)((Object)string)).mSignature = new SignatureSingleData();
        ((CheckTransaction)((Object)string)).mSignature.setSign((NativeSecp256k1.RecoverableSignature)privateKey);
        String string = new BytesData(((CheckTransaction)((Object)string)).encode(false)).toHexString("Mc");
        return new TransactionSign(string);
    }

    public static final class Builder {
        private CheckTransaction mCheck;

        public Builder(BigInteger bigInteger, String string) {
            this.mCheck = new CheckTransaction(bigInteger, string);
        }

        public Builder setCoin(String string) {
            boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid coin passed: %s", objectArray2));
            CheckTransaction.access$002(objectArray2.mCheck, StringHelper.strrpad((int)10, (String)string));
            return objectArray2;
        }

        public Builder setValue(BigDecimal bigDecimal) {
            Builder builder = this;
            CheckTransaction.access$102(builder.mCheck, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
            return builder;
        }

        public Builder setValue(double d) {
            return this.setValue(new BigDecimal(String.valueOf(d)));
        }

        public Builder setDueBlock(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransaction.access$202(builder.mCheck, bigInteger);
            return builder;
        }

        public CheckTransaction build() {
            Builder builder = this;
            Preconditions.checkNotNull((Object)builder.mCheck.mValue, (String)"Value must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mDueBlock, (String)"Due block must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mNonce, (String)"Nonce required");
            Preconditions.checkNotNull((Object)builder.mCheck.mPassphrase, (String)"Passphrase required");
            return builder.mCheck;
        }
    }
}

