/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;

public class BCResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="result")
    public Result result;
    public ErrorResult error;

    public static <T> BCResult<T> copyError(BCResult<?> bCResult) {
        BCResult bCResult2;
        BCResult bCResult3 = bCResult2;
        bCResult3();
        bCResult3.statusCode = bCResult.statusCode;
        bCResult2.error = bCResult.error;
        return bCResult2;
    }

    public boolean isOk() {
        return this.error == null && this.result != null;
    }

    @Nonnull
    public String toString() {
        String string = "BCResult{code=%s, result=%s, message=%s}";
        Object[] objectArray = new Object[3];
        int n = 0;
        Object object = this.error;
        object = object != null ? ((ErrorResult)object).getResultCode().name() : "{no error code}";
        objectArray[n] = object;
        n = 1;
        object = this.result != null ? "{has result: " + this.result.getClass().getName() + "}" : "null";
        objectArray[n] = object;
        int n2 = 2;
        Object object2 = this.error;
        object2 = object2 != null ? ((ErrorResult)object2).getMessage() : "null";
        objectArray[n2] = object2;
        return String.format(string, objectArray);
    }

    @Deprecated
    public boolean isSuccess() {
        return this.statusCode == 200 && this.error == null;
    }

    public static final class ErrorResult {
        public int code;
        public String message;
        public String data;

        public ResultCode getResultCode() {
            return ResultCode.findByCode(this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            String string = this.data;
            if (string != null && !string.isEmpty()) {
                return this.data;
            }
            return this.message;
        }
    }

    public static enum ResultCode {
        UnknownError(-1),
        Success(0),
        WrongNonce(101),
        CoinNotExists(102),
        CoinReserveNotSufficient(103),
        TxTooLarge(105),
        DecodeError(106),
        InsufficientFunds(107),
        TxPayloadTooLarge(109),
        TxServiceDataTooLarge(110),
        InvalidMultisendData(111),
        CoinSupplyOverflow(112),
        TxFromSenderAlreadyInMempool(113),
        TooLowGasPrice(114),
        WrongChainId(115),
        CoinAlreadyExists(201),
        WrongCrr(202),
        InvalidCoinSymbol(203),
        InvalidCoinName(204),
        WrongCoinSupply(205),
        CrossConvert(301),
        MaximumValueToSellReached(302),
        MinimumValueToBuylReached(303),
        CandidateExists(401),
        WrongCommission(402),
        CandidateNotFound(403),
        StakeNotFound(404),
        InsufficientStake(405),
        IsNotOwnerOfCandidate(406),
        IncorrectPubKey(407),
        StakeShouldBePositive(408),
        TooLowStake(409),
        CheckInvalidLock(501),
        CheckExpired(502),
        CheckUsed(503),
        TooHighGasPrice(504),
        WrongGasCoin(505),
        IncorrectWeights(601),
        MultisigExists(602),
        MultisigNotExists(603),
        IncorrectMultiSignature(604),
        TooLargeOwnersList(605);

        final int resVal;

        private ResultCode(int n2) {
            this.resVal = n2;
        }

        public static boolean isKnownError(int n) {
            ResultCode[] resultCodeArray = ResultCode.values();
            int n2 = resultCodeArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n != resultCodeArray[i].getValue()) continue;
                return true;
            }
            return false;
        }

        public static ResultCode findByCode(int n) {
            for (ResultCode resultCode : ResultCode.values()) {
                if (n != resultCode.getValue()) continue;
                return resultCode;
            }
            return UnknownError;
        }

        public int getValue() {
            return this.resVal;
        }
    }
}

