/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainApi;
import network.minter.blockchain.api.BlockChainEventEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.EventList;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.log.Mint;
import retrofit2.Call;

public class BlockChainEventRepository
extends DataRepository<BlockChainEventEndpoint>
implements DataRepository.Configurator {
    public BlockChainEventRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(EventList.class, (Object)new EventTypeDeserializer(MinterBlockChainApi.getInstance().getGsonBuilder()));
    }

    public Call<BCResult<EventList>> getEvents(long blockHeight) {
        return ((BlockChainEventEndpoint)this.getInstantService()).getByHeight(blockHeight);
    }

    @Nonnull
    protected Class<BlockChainEventEndpoint> getServiceClass() {
        return BlockChainEventEndpoint.class;
    }

    public static final class EventTypeDeserializer
    implements JsonDeserializer<EventList> {
        private final Gson mGson;

        EventTypeDeserializer(GsonBuilder builder) {
            this.mGson = builder.create();
        }

        public EventList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            EventList eventList = new EventList();
            eventList.events = new ArrayList<EventList.EventItem>(0);
            if (json.isJsonNull() || json.getAsJsonObject().isJsonNull() || !json.getAsJsonObject().has("events")) {
                return eventList;
            }
            JsonArray arr = json.getAsJsonObject().get("events").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                EventList.EventItem event = new EventList.EventItem();
                JsonObject item = arr.get(i).getAsJsonObject();
                event.type = EventList.Type.findByName(item.get("type").getAsString());
                if (event.type == null) {
                    Mint.e((String)"Unknown event type: %s", (Object[])new Object[]{item.get("type").getAsString()});
                    continue;
                }
                JsonObject itemValue = item.get("value").getAsJsonObject();
                event.value = (EventList.BaseEvent)this.mGson.fromJson((JsonElement)itemValue, event.type.getCls());
                eventList.events.add(event);
            }
            return eventList;
        }
    }
}

