/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.BlockChainCoinEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainCoinRepository
extends DataRepository<BlockChainCoinEndpoint> {
    public BlockChainCoinRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<BCResult<Coin>> getCoinInfo(@Nonnull String symbol) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinInformation((String)Preconditions.checkNotNull((Object)symbol, (String)"Symbol required"));
    }

    public Call<BCResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigDecimal valueToSell, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToSell(coinToSell, valueToSell.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<BCResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String coinToSell, BigInteger valueToSell, @Nonnull String coinToBuy) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinExchangeCurrencyToSell(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToSell.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    public Call<BCResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigDecimal valueToBuy, @Nonnull String coinToBuy) {
        return this.getCoinExchangeCurrencyToBuy(coinToSell, valueToBuy.multiply(Transaction.VALUE_MUL_DEC).toBigInteger(), coinToBuy);
    }

    public Call<BCResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String coinToSell, BigInteger valueToBuy, @Nonnull String coinToBuy) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinExchangeCurrencyToBuy(((String)Preconditions.checkNotNull((Object)coinToSell, (String)"Source coin required")).toUpperCase(), valueToBuy.toString(), ((String)Preconditions.checkNotNull((Object)coinToBuy, (String)"Target coin required")).toUpperCase());
    }

    @Nonnull
    protected Class<BlockChainCoinEndpoint> getServiceClass() {
        return BlockChainCoinEndpoint.class;
    }
}

