/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCoinSell
extends Operation {
    public static final Parcelable.Creator<TxCoinSell> CREATOR = new Parcelable.Creator<TxCoinSell>(){

        public TxCoinSell createFromParcel(Parcel in) {
            return new TxCoinSell(in);
        }

        public TxCoinSell[] newArray(int size) {
            return new TxCoinSell[size];
        }
    };
    private String mCoinToSell;
    private BigInteger mValueToSell;
    private String mCoinToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSell(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCoinSell(Parcel in) {
        super(in);
        this.mCoinToSell = in.readString();
        this.mValueToSell = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mCoinToBuy = in.readString();
        this.mMinValueToBuy = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoinToSell);
        dest.writeValue((Object)this.mValueToSell);
        dest.writeString(this.mCoinToBuy);
        dest.writeValue((Object)this.mMinValueToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSell setCoinToSell(String coin) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSell setCoinToBuy(String coin) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public BigInteger getValueToSellBigInteger() {
        return this.mValueToSell;
    }

    public BigDecimal getValueToSell() {
        return new BigDecimal(this.mValueToSell).divide(Transaction.VALUE_MUL_DEC);
    }

    public double getValueToSellDouble() {
        return this.getValueToSell().doubleValue();
    }

    public TxCoinSell setValueToSell(double amount) {
        return this.setValueToSell(new BigDecimal(String.valueOf(amount)));
    }

    public TxCoinSell setValueToSell(BigInteger amount) {
        this.mValueToSell = amount;
        return this;
    }

    public TxCoinSell setValueToSell(BigDecimal amount) {
        return this.setValueToSell(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCoinSell setMinValueToBuy(double amount) {
        return this.setMinValueToBuy(new BigDecimal(String.valueOf(amount)));
    }

    public TxCoinSell setMinValueToBuy(BigInteger amount) {
        this.mMinValueToBuy = amount;
        return this;
    }

    public TxCoinSell setMinValueToBuy(BigDecimal amount) {
        return this.setMinValueToBuy(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    @Override
    public OperationType getType() {
        return OperationType.SellCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoinToBuy", this.mCoinToBuy != null && this.mCoinToBuy.length() > 2 && this.mCoinToBuy.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mCoinToSell", this.mCoinToSell != null && this.mCoinToSell.length() > 2 && this.mCoinToSell.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mValueToSell", this.mValueToSell != null, "Value must be set").addResult("mMinValueToBuy", this.mMinValueToBuy != null, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mCoinToSell, this.mValueToSell, this.mCoinToBuy, this.mMinValueToBuy});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoinToSell = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mValueToSell = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(1, decoded));
        this.mCoinToBuy = StringHelper.bytesToString((byte[])this.fromRawRlp(2, decoded));
        this.mMinValueToBuy = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(3, decoded));
    }
}

