/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import java.io.File;
import net.sqlcipher.DatabaseErrorHandler;
import net.sqlcipher.DefaultDatabaseErrorHandler;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDatabaseHook;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private final SQLiteDatabaseHook mHook;
    private final DatabaseErrorHandler mErrorHandler;
    private boolean mEnableWriteAheadLogging;
    private boolean mDeferSetWriteAheadLoggingEnabled;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, factory, version, null, new DefaultDatabaseErrorHandler());
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, SQLiteDatabaseHook hook) {
        this(context, name, factory, version, hook, new DefaultDatabaseErrorHandler());
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, SQLiteDatabaseHook hook, DatabaseErrorHandler errorHandler) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException("DatabaseErrorHandler param value can't be null.");
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mHook = hook;
        this.mErrorHandler = errorHandler;
    }

    public synchronized SQLiteDatabase getWritableDatabase(String password) {
        return this.getWritableDatabase(password == null ? null : password.toCharArray());
    }

    public synchronized SQLiteDatabase getWritableDatabase(char[] password) {
        return this.getWritableDatabase(password == null ? null : SQLiteDatabase.getBytes(password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase(byte[] password) {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        if (this.mDatabase != null) {
            this.mDatabase.lock();
        }
        try {
            this.mIsInitializing = true;
            if (this.mName == null) {
                db = SQLiteDatabase.create(null, "");
            } else {
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                File dbPathFile = new File(path);
                if (!dbPathFile.exists()) {
                    dbPathFile.getParentFile().mkdirs();
                }
                db = SQLiteDatabase.openOrCreateDatabase(path, password, this.mFactory, this.mHook, this.mErrorHandler);
            }
            if (this.mDeferSetWriteAheadLoggingEnabled) {
                this.mEnableWriteAheadLogging = db.enableWriteAheadLogging();
            }
            this.onConfigure(db);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception exception) {}
                    this.mDatabase.unlock();
                }
                this.mDatabase = db;
            } else {
                if (this.mDatabase != null) {
                    this.mDatabase.unlock();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    public synchronized SQLiteDatabase getReadableDatabase(String password) {
        return this.getReadableDatabase(password == null ? null : password.toCharArray());
    }

    public synchronized SQLiteDatabase getReadableDatabase(char[] password) {
        return this.getReadableDatabase(password == null ? null : SQLiteDatabase.getBytes(password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getReadableDatabase(byte[] password) {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase(password);
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                File databasePath = new File(path);
                File databasesDirectory = new File(this.mContext.getDatabasePath(this.mName).getParent());
                if (!databasesDirectory.exists()) {
                    databasesDirectory.mkdirs();
                }
                if (!databasePath.exists()) {
                    this.mIsInitializing = false;
                    db = this.getWritableDatabase(password);
                    this.mIsInitializing = true;
                    db.close();
                }
                if ((db = SQLiteDatabase.openDatabase(path, password, this.mFactory, 1, this.mHook, this.mErrorHandler)).getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mEnableWriteAheadLogging != enabled) {
                if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                    if (enabled) {
                        this.mDatabase.enableWriteAheadLogging();
                    } else {
                        this.mDatabase.disableWriteAheadLogging();
                    }
                    this.mEnableWriteAheadLogging = enabled;
                } else {
                    this.mDeferSetWriteAheadLoggingEnabled = enabled;
                }
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    public void onConfigure(SQLiteDatabase db) {
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onOpen(SQLiteDatabase db) {
    }
}

