/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.util.Log;
import java.util.Map;
import net.sqlcipher.database.SQLiteClosable;
import net.sqlcipher.database.SQLiteCompiledSql;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDebug;

public abstract class SQLiteProgram
extends SQLiteClosable {
    private static final String TAG = "SQLiteProgram";
    @Deprecated
    protected SQLiteDatabase mDatabase;
    final String mSql;
    @Deprecated
    protected long nHandle = 0L;
    private SQLiteCompiledSql mCompiledSql;
    @Deprecated
    protected long nStatement = 0L;

    SQLiteProgram(SQLiteDatabase db, String sql) {
        String prefixSql;
        this.mDatabase = db;
        this.mSql = sql.trim();
        db.acquireReference();
        db.addSQLiteClosable(this);
        this.nHandle = db.mNativeHandle;
        int crudPrefixLength = 6;
        String string = prefixSql = this.mSql.length() >= crudPrefixLength ? this.mSql.substring(0, crudPrefixLength) : this.mSql;
        if (!(prefixSql.equalsIgnoreCase("INSERT") || prefixSql.equalsIgnoreCase("UPDATE") || prefixSql.equalsIgnoreCase("REPLAC") || prefixSql.equalsIgnoreCase("DELETE") || prefixSql.equalsIgnoreCase("SELECT"))) {
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            this.nStatement = this.mCompiledSql.nStatement;
            return;
        }
        this.mCompiledSql = db.getCompiledStatementForSql(sql);
        if (this.mCompiledSql == null) {
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            this.mCompiledSql.acquire();
            db.addToCompiledQueries(sql, this.mCompiledSql);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("Created DbObj (id#" + this.mCompiledSql.nStatement + ") for sql: " + sql));
            }
        } else if (!this.mCompiledSql.acquire()) {
            long last = this.mCompiledSql.nStatement;
            this.mCompiledSql = new SQLiteCompiledSql(db, sql);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("** possible bug ** Created NEW DbObj (id#" + this.mCompiledSql.nStatement + ") because the previously created DbObj (id#" + last + ") was not released for sql:" + sql));
            }
        }
        this.nStatement = this.mCompiledSql.nStatement;
    }

    protected void onAllReferencesReleased() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
        this.mDatabase.removeSQLiteClosable(this);
    }

    protected void onAllReferencesReleasedFromContainer() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCompiledSqlIfNotInCache() {
        if (this.mCompiledSql == null) {
            return;
        }
        Map<String, SQLiteCompiledSql> map = this.mDatabase.mCompiledQueries;
        synchronized (map) {
            if (!this.mDatabase.mCompiledQueries.containsValue(this.mCompiledSql)) {
                this.mCompiledSql.releaseSqlStatement();
                this.mCompiledSql = null;
                this.nStatement = 0L;
            } else {
                this.mCompiledSql.release();
            }
        }
    }

    public final long getUniqueId() {
        return this.nStatement;
    }

    String getSqlString() {
        return this.mSql;
    }

    @Deprecated
    protected void compile(String sql, boolean forceCompilation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindNull(int index) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_null(index);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindLong(int index, long value) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_long(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindDouble(int index, double value) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_double(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_string(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_bind_blob(index, value);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        this.acquireReference();
        try {
            this.native_clear_bindings();
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.mDatabase.isOpen()) {
            return;
        }
        this.mDatabase.lock();
        try {
            this.releaseReference();
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    @Deprecated
    protected final native void native_compile(String var1);

    @Deprecated
    protected final native void native_finalize();

    protected final native void native_bind_null(int var1);

    protected final native void native_bind_long(int var1, long var2);

    protected final native void native_bind_double(int var1, double var2);

    protected final native void native_bind_string(int var1, String var2);

    protected final native void native_bind_blob(int var1, byte[] var2);

    private final native void native_clear_bindings();
}

