/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.math.ScalarOps;

public class EdDSAEngine
extends Signature {
    private MessageDigest digest;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
    private EdDSAKey key;

    public EdDSAEngine() {
        super("EdDSA");
    }

    public EdDSAEngine(MessageDigest digest) {
        this();
        this.digest = digest;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        EdDSAPrivateKey privKey;
        if (this.digest != null) {
            this.digest.reset();
        }
        this.baos.reset();
        if (privateKey instanceof EdDSAPrivateKey) {
            privKey = (EdDSAPrivateKey)privateKey;
            this.key = privKey;
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.key.getParams().getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyException("cannot get required digest " + this.key.getParams().getHashAlgorithm() + " for private key.");
                }
            } else if (!this.key.getParams().getHashAlgorithm().equals(this.digest.getAlgorithm())) {
                throw new InvalidKeyException("Key hash algorithm does not match chosen digest");
            }
        } else {
            throw new InvalidKeyException("cannot identify EdDSA private key.");
        }
        int b = privKey.getParams().getCurve().getField().getb();
        this.digest.update(privKey.getH(), b / 8, b / 4 - b / 8);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (this.digest != null) {
            this.digest.reset();
        }
        this.baos.reset();
        if (publicKey instanceof EdDSAPublicKey) {
            this.key = (EdDSAPublicKey)publicKey;
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.key.getParams().getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyException("cannot get required digest " + this.key.getParams().getHashAlgorithm() + " for private key.");
                }
            } else if (!this.key.getParams().getHashAlgorithm().equals(this.digest.getAlgorithm())) {
                throw new InvalidKeyException("Key hash algorithm does not match chosen digest");
            }
        } else {
            throw new InvalidKeyException("cannot identify EdDSA public key.");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.baos.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.baos.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        Curve curve = this.key.getParams().getCurve();
        ScalarOps sc = this.key.getParams().getScalarOps();
        byte[] a = ((EdDSAPrivateKey)this.key).geta();
        byte[] message = this.baos.toByteArray();
        byte[] r = this.digest.digest(message);
        r = sc.reduce(r);
        GroupElement R = this.key.getParams().getB().scalarMultiply(r);
        byte[] Rbyte = R.toByteArray();
        this.digest.update(Rbyte);
        this.digest.update(((EdDSAPrivateKey)this.key).getAbyte());
        byte[] h = this.digest.digest(message);
        h = sc.reduce(h);
        byte[] S = sc.multiplyAndAdd(h, a, r);
        int b = curve.getField().getb();
        ByteBuffer out = ByteBuffer.allocate(b / 4);
        out.put(Rbyte).put(S);
        return out.array();
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        Curve curve = this.key.getParams().getCurve();
        int b = curve.getField().getb();
        if (sigBytes.length != b / 4) {
            throw new SignatureException("signature length is wrong");
        }
        this.digest.update(sigBytes, 0, b / 8);
        this.digest.update(((EdDSAPublicKey)this.key).getAbyte());
        byte[] message = this.baos.toByteArray();
        byte[] h = this.digest.digest(message);
        h = this.key.getParams().getScalarOps().reduce(h);
        byte[] Sbyte = Arrays.copyOfRange(sigBytes, b / 8, b / 4);
        GroupElement R = this.key.getParams().getB().doubleScalarMultiplyVariableTime(((EdDSAPublicKey)this.key).getNegativeA(), h, Sbyte);
        byte[] Rcalc = R.toByteArray();
        for (int i = 0; i < Rcalc.length; ++i) {
            if (Rcalc[i] == sigBytes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

