/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.ttddyy.observation.boot.autoconfigure.DataSourceNameResolver;
import net.ttddyy.observation.boot.autoconfigure.DataSourceObservationBeanPostProcessor;
import org.springframework.util.ClassUtils;

public class DefaultDataSourceNameResolver
implements DataSourceNameResolver {
    private static final boolean isHikariPresent = ClassUtils.isPresent((String)"com.zaxxer.hikari.HikariDataSource", (ClassLoader)DataSourceObservationBeanPostProcessor.class.getClassLoader());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String resolve(String beanName, DataSource dataSource) {
        HikariDataSource hikariDataSource;
        if (isHikariPresent && dataSource instanceof HikariDataSource && (hikariDataSource = (HikariDataSource)dataSource).getPoolName() != null && !hikariDataSource.getPoolName().startsWith("HikariPool-")) {
            return hikariDataSource.getPoolName();
        }
        try (Connection connection = dataSource.getConnection();){
            String catalogName = connection.getCatalog();
            if (catalogName == null) return beanName;
            String string = catalogName;
            return string;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return beanName;
    }
}

