/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.lifecycle;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.DataSourceProxyException;
import net.ttddyy.dsproxy.listener.lifecycle.JdbcLifecycleEventListener;

public class JdbcLifecycleEventListenerUtils {
    private static final Map<Method, Method> beforeMethods = new HashMap<Method, Method>();
    private static final Map<Method, Method> afterMethods = new HashMap<Method, Method>();
    private static final Map<Class<?>, Method> beforeMethodForUnwrap = new HashMap();
    private static final Map<Class<?>, Method> afterMethodForUnwrap = new HashMap();
    private static final Map<Class<?>, Method> beforeMethodForIsWrapperFor = new HashMap();
    private static final Map<Class<?>, Method> afterMethodForIsWrapperFor = new HashMap();

    private static void init() {
        List<Class> proxiedClasses = Arrays.asList(DataSource.class, Connection.class, Statement.class, PreparedStatement.class, CallableStatement.class, ResultSet.class);
        HashMap<String, Method> lifeCycleMethodByName = new HashMap<String, Method>();
        for (Method method : JdbcLifecycleEventListener.class.getMethods()) {
            lifeCycleMethodByName.put(method.getName(), method);
        }
        for (Class proxiedClass : proxiedClasses) {
            for (Method method : proxiedClass.getMethods()) {
                boolean isWrapperMethod = method.getDeclaringClass() == Wrapper.class;
                String beforeMethodName = JdbcLifecycleEventListenerUtils.getTargetMethodName(method, proxiedClass, true);
                String afterMethodName = JdbcLifecycleEventListenerUtils.getTargetMethodName(method, proxiedClass, false);
                Method beforeMethod = (Method)lifeCycleMethodByName.get(beforeMethodName);
                Method afterMethod = (Method)lifeCycleMethodByName.get(afterMethodName);
                if (isWrapperMethod) {
                    if ("unwrap".equals(method.getName())) {
                        beforeMethodForUnwrap.put(proxiedClass, beforeMethod);
                        afterMethodForUnwrap.put(proxiedClass, afterMethod);
                        continue;
                    }
                    beforeMethodForIsWrapperFor.put(proxiedClass, beforeMethod);
                    afterMethodForIsWrapperFor.put(proxiedClass, afterMethod);
                    continue;
                }
                beforeMethods.put(method, beforeMethod);
                afterMethods.put(method, afterMethod);
            }
        }
    }

    public static Method getListenerMethod(Method invokedMethod, Object proxyTarget, boolean isBefore) {
        boolean isWrapperMethod;
        Class<?> declaringClass = invokedMethod.getDeclaringClass();
        boolean bl = isWrapperMethod = declaringClass == Wrapper.class;
        if (isWrapperMethod) {
            Class key;
            if (proxyTarget instanceof DataSource) {
                key = DataSource.class;
            } else if (proxyTarget instanceof Connection) {
                key = Connection.class;
            } else if (proxyTarget instanceof CallableStatement) {
                key = CallableStatement.class;
            } else if (proxyTarget instanceof PreparedStatement) {
                key = PreparedStatement.class;
            } else if (proxyTarget instanceof Statement) {
                key = Statement.class;
            } else if (proxyTarget instanceof ResultSet) {
                key = ResultSet.class;
            } else {
                throw new DataSourceProxyException("Unknown target type. proxyTarget=" + proxyTarget);
            }
            if ("unwrap".equals(invokedMethod.getName())) {
                if (isBefore) {
                    return beforeMethodForUnwrap.get(key);
                }
                return afterMethodForUnwrap.get(key);
            }
            if (isBefore) {
                return beforeMethodForIsWrapperFor.get(key);
            }
            return afterMethodForIsWrapperFor.get(key);
        }
        if (isBefore) {
            return beforeMethods.get(invokedMethod);
        }
        return afterMethods.get(invokedMethod);
    }

    public static String getTargetMethodName(Method invokedMethod, Class<?> proxiedClass, boolean isBefore) {
        String methodName = invokedMethod.getName();
        StringBuilder sb = new StringBuilder();
        if (isBefore) {
            sb.append("before");
        } else {
            sb.append("after");
        }
        if (JdbcLifecycleEventListenerUtils.isWrapperMethod(methodName)) {
            if ("unwrap".equals(methodName)) {
                sb.append("UnwrapOn");
            } else {
                sb.append("IsWrapperForOn");
            }
            if (proxiedClass == DataSource.class) {
                sb.append("DataSource");
            } else if (proxiedClass == Connection.class) {
                sb.append("Connection");
            } else if (proxiedClass == CallableStatement.class) {
                sb.append("CallableStatement");
            } else if (proxiedClass == PreparedStatement.class) {
                sb.append("PreparedStatement");
            } else if (proxiedClass == Statement.class) {
                sb.append("Statement");
            } else if (proxiedClass == ResultSet.class) {
                sb.append("ResultSet");
            }
            return sb.toString();
        }
        sb.append(Character.toUpperCase(methodName.charAt(0)));
        sb.append(methodName.substring(1));
        sb.append("On");
        Class<?> declaringClass = invokedMethod.getDeclaringClass();
        if (declaringClass == CommonDataSource.class) {
            sb.append("DataSource");
        } else {
            sb.append(declaringClass.getSimpleName());
        }
        return sb.toString();
    }

    private static boolean isWrapperMethod(String methodName) {
        return "unwrap".equals(methodName) || "isWrapperFor".equals(methodName);
    }

    static {
        JdbcLifecycleEventListenerUtils.init();
    }
}

