/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.ChainListener;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.proxy.StatementMethodNames;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class StatementProxyLogic {
    private static final Set<String> METHODS_TO_INTERCEPT = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(StatementMethodNames.BATCH_PARAM_METHODS);
            this.addAll(StatementMethodNames.EXEC_METHODS);
            this.addAll(StatementMethodNames.JDBC4_METHODS);
            this.addAll(StatementMethodNames.GET_CONNECTION_METHOD);
            this.addAll(StatementMethodNames.METHODS_TO_RETURN_RESULTSET);
            this.add("getDataSourceName");
            this.add("toString");
            this.add("getTarget");
        }
    });
    private Statement stmt;
    private ConnectionInfo connectionInfo;
    private List<String> batchQueries = new ArrayList<String>();
    private Connection proxyConnection;
    private ProxyConfig proxyConfig;

    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                return StatementProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.stmt, this.connectionInfo, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.stmt, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.stmt.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.stmt.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.connectionInfo.getDataSourceName();
        }
        if ("getTarget".equals(methodName)) {
            return this.stmt;
        }
        ChainListener queryListener = this.proxyConfig.getQueryListener();
        QueryTransformer queryTransformer = this.proxyConfig.getQueryTransformer();
        JdbcProxyFactory proxyFactory = this.proxyConfig.getJdbcProxyFactory();
        if (StatementMethodNames.JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.stmt.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.stmt.isWrapperFor(clazz);
            }
        }
        if (StatementMethodNames.GET_CONNECTION_METHOD.contains(methodName)) {
            return this.proxyConnection;
        }
        if ("addBatch".equals(methodName) || "clearBatch".equals(methodName)) {
            if ("addBatch".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
                String query = (String)args[0];
                Class<Statement> clazz = Statement.class;
                int batchCount = this.batchQueries.size();
                TransformInfo transformInfo = new TransformInfo(clazz, this.connectionInfo.getDataSourceName(), query, true, batchCount);
                String transformedQuery = queryTransformer.transformQuery(transformInfo);
                args[0] = transformedQuery;
                this.batchQueries.add(transformedQuery);
            } else if ("clearBatch".equals(methodName)) {
                this.batchQueries.clear();
            }
            try {
                return method.invoke((Object)this.stmt, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        boolean isBatchExecute = false;
        int batchSize = 0;
        if (StatementMethodNames.BATCH_EXEC_METHODS.contains(methodName)) {
            for (String batchQuery : this.batchQueries) {
                queries.add(new QueryInfo(batchQuery));
            }
            batchSize = this.batchQueries.size();
            this.batchQueries.clear();
            isBatchExecute = true;
        } else if (StatementMethodNames.QUERY_EXEC_METHODS.contains(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
            String query = (String)args[0];
            TransformInfo transformInfo = new TransformInfo(Statement.class, this.connectionInfo.getDataSourceName(), query, false, 0);
            String transformedQuery = queryTransformer.transformQuery(transformInfo);
            args[0] = transformedQuery;
            queries.add(new QueryInfo(transformedQuery));
        }
        ExecutionInfo execInfo = new ExecutionInfo(this.connectionInfo, this.stmt, isBatchExecute, batchSize, method, args);
        queryListener.beforeQuery(execInfo, queries);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.stmt, args);
            long afterTime = System.currentTimeMillis();
            if (StatementMethodNames.METHODS_TO_RETURN_RESULTSET.contains(methodName)) {
                retVal = proxyFactory.createResultSet((ResultSet)retVal, this.connectionInfo, this.proxyConfig);
            }
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            execInfo.setSuccess(true);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            execInfo.setSuccess(false);
            throw ex.getTargetException();
        }
        finally {
            queryListener.afterQuery(execInfo, queries);
        }
    }

    public static class Builder {
        private Statement stmt;
        private ConnectionInfo connectionInfo;
        private Connection proxyConnection;
        private ProxyConfig proxyConfig;

        public static Builder create() {
            return new Builder();
        }

        public StatementProxyLogic build() {
            StatementProxyLogic logic = new StatementProxyLogic();
            logic.stmt = this.stmt;
            logic.connectionInfo = this.connectionInfo;
            logic.proxyConnection = this.proxyConnection;
            logic.proxyConfig = this.proxyConfig;
            return logic;
        }

        public Builder statement(Statement statement) {
            this.stmt = statement;
            return this;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder proxyConnection(Connection proxyConnection) {
            this.proxyConnection = proxyConnection;
            return this;
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }
    }
}

