/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.ChainListener;
import net.ttddyy.dsproxy.listener.MethodExecutionListenerUtils;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ParameterKey;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import net.ttddyy.dsproxy.proxy.StatementMethodNames;
import net.ttddyy.dsproxy.transform.ParameterReplacer;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class PreparedStatementProxyLogic {
    private PreparedStatement ps;
    private String query;
    private ConnectionInfo connectionInfo;
    private Map<ParameterKey, ParameterSetOperation> parameters = new LinkedHashMap<ParameterKey, ParameterSetOperation>();
    private List<Map<ParameterKey, ParameterSetOperation>> batchParameters = new ArrayList<Map<ParameterKey, ParameterSetOperation>>();
    private Connection proxyConnection;
    private ProxyConfig proxyConfig;

    public Object invoke(Method method, Object[] args) throws Throwable {
        return MethodExecutionListenerUtils.invoke(new MethodExecutionListenerUtils.MethodExecutionCallback(){

            @Override
            public Object execute(Object proxyTarget, Method method, Object[] args) throws Throwable {
                return PreparedStatementProxyLogic.this.performQueryExecutionListener(method, args);
            }
        }, this.proxyConfig, this.ps, this.connectionInfo, method, args);
    }

    private Object performQueryExecutionListener(Method method, Object[] args) throws Throwable {
        QueryInfo queryInfo;
        String methodName = method.getName();
        if (!StatementMethodNames.METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        ParameterTransformer parameterTransformer = this.proxyConfig.getParameterTransformer();
        ChainListener queryListener = this.proxyConfig.getQueryListener();
        JdbcProxyFactory proxyFactory = this.proxyConfig.getJdbcProxyFactory();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ps.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.ps.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.connectionInfo.getDataSourceName();
        }
        if ("getTarget".equals(methodName)) {
            return this.ps;
        }
        if (StatementMethodNames.JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.ps.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.ps.isWrapperFor(clazz);
            }
        }
        if (StatementMethodNames.GET_CONNECTION_METHOD.contains(methodName)) {
            return this.proxyConnection;
        }
        if (StatementMethodNames.METHODS_TO_OPERATE_PARAMETER.contains(methodName)) {
            if (StatementMethodNames.PARAMETER_METHODS.contains(methodName)) {
                if ("clearParameters".equals(methodName)) {
                    this.parameters.clear();
                } else {
                    ParameterKey parameterKey;
                    if (args[0] instanceof Integer) {
                        parameterKey = new ParameterKey((Integer)args[0]);
                    } else if (args[0] instanceof String) {
                        parameterKey = new ParameterKey((String)args[0]);
                    } else {
                        return MethodUtils.proceedExecution(method, this.ps, args);
                    }
                    this.parameters.put(parameterKey, new ParameterSetOperation(method, args));
                }
            } else if (StatementMethodNames.BATCH_PARAM_METHODS.contains(methodName)) {
                if ("addBatch".equals(methodName)) {
                    this.transformParameters(parameterTransformer, true, this.batchParameters.size());
                    LinkedHashMap<ParameterKey, ParameterSetOperation> newParams = new LinkedHashMap<ParameterKey, ParameterSetOperation>(this.parameters);
                    this.batchParameters.add(newParams);
                    this.parameters.clear();
                } else if ("clearBatch".equals(methodName)) {
                    this.batchParameters.clear();
                }
            }
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        boolean isBatchExecution = false;
        int batchSize = 0;
        if (StatementMethodNames.BATCH_EXEC_METHODS.contains(methodName)) {
            queryInfo = new QueryInfo(this.query);
            for (Map<ParameterKey, ParameterSetOperation> params : this.batchParameters) {
                queryInfo.getParametersList().add(new ArrayList<ParameterSetOperation>(params.values()));
            }
            queries.add(queryInfo);
            batchSize = this.batchParameters.size();
            this.batchParameters.clear();
            isBatchExecution = true;
        } else if (StatementMethodNames.QUERY_EXEC_METHODS.contains(methodName)) {
            this.transformParameters(parameterTransformer, false, 0);
            queryInfo = new QueryInfo(this.query);
            queryInfo.getParametersList().add(new ArrayList<ParameterSetOperation>(this.parameters.values()));
            queries.add(queryInfo);
        }
        ExecutionInfo execInfo = new ExecutionInfo(this.connectionInfo, this.ps, isBatchExecution, batchSize, method, args);
        queryListener.beforeQuery(execInfo, queries);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.ps, args);
            long afterTime = System.currentTimeMillis();
            if (StatementMethodNames.METHODS_TO_RETURN_RESULTSET.contains(methodName)) {
                retVal = proxyFactory.createResultSet((ResultSet)retVal, this.connectionInfo, this.proxyConfig);
            }
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            execInfo.setSuccess(true);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            execInfo.setSuccess(false);
            throw ex.getTargetException();
        }
        finally {
            queryListener.afterQuery(execInfo, queries);
        }
    }

    private void transformParameters(ParameterTransformer parameterTransformer, boolean isBatch, int count) throws SQLException, IllegalAccessException, InvocationTargetException {
        ParameterReplacer parameterReplacer = new ParameterReplacer(this.parameters);
        TransformInfo transformInfo = new TransformInfo(this.ps.getClass(), this.connectionInfo.getDataSourceName(), this.query, isBatch, count);
        parameterTransformer.transformParameters(parameterReplacer, transformInfo);
        if (parameterReplacer.isModified()) {
            this.ps.clearParameters();
            Map<ParameterKey, ParameterSetOperation> modifiedParameters = parameterReplacer.getModifiedParameters();
            for (ParameterSetOperation operation : modifiedParameters.values()) {
                Method paramMethod = operation.getMethod();
                Object[] paramArgs = operation.getArgs();
                paramMethod.invoke((Object)this.ps, paramArgs);
            }
            this.parameters = modifiedParameters;
        }
    }

    public static class Builder {
        private PreparedStatement ps;
        private String query;
        private ConnectionInfo connectionInfo;
        private Connection proxyConnection;
        private ProxyConfig proxyConfig;

        public static Builder create() {
            return new Builder();
        }

        public PreparedStatementProxyLogic build() {
            PreparedStatementProxyLogic logic = new PreparedStatementProxyLogic();
            logic.ps = this.ps;
            logic.query = this.query;
            logic.connectionInfo = this.connectionInfo;
            logic.proxyConnection = this.proxyConnection;
            logic.proxyConfig = this.proxyConfig;
            return logic;
        }

        public Builder preparedStatement(PreparedStatement ps) {
            this.ps = ps;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder proxyConnection(Connection proxyConnection) {
            this.proxyConnection = proxyConnection;
            return this;
        }

        public Builder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }
    }
}

