/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockWindows;
import net.time4j.range.DateWindows;
import net.time4j.range.IntervalEdge;
import net.time4j.range.MomentWindows;
import net.time4j.range.TimestampWindows;

public abstract class IntervalCollection<T extends Temporal<? super T>>
implements Serializable {
    private final transient List<ChronoInterval<T>> intervals;

    IntervalCollection() {
        this.intervals = Collections.emptyList();
    }

    IntervalCollection(List<ChronoInterval<T>> list) {
        this.intervals = Collections.unmodifiableList(list);
    }

    public static IntervalCollection<PlainDate> onDateAxis() {
        return DateWindows.EMPTY;
    }

    public static IntervalCollection<PlainTime> onClockAxis() {
        return ClockWindows.EMPTY;
    }

    public static IntervalCollection<PlainTimestamp> onTimestampAxis() {
        return TimestampWindows.EMPTY;
    }

    public static IntervalCollection<Moment> onMomentAxis() {
        return MomentWindows.EMPTY;
    }

    public List<ChronoInterval<T>> getIntervals() {
        return this.intervals;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public T getMinimum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no minimum.");
        }
        return this.intervals.get(0).getStart().getTemporal();
    }

    public T getMaximum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no maximum.");
        }
        int n = this.intervals.size();
        Boundary<T> boundary = this.intervals.get(n - 1).getEnd();
        Object object = boundary.getTemporal();
        if (boundary.isInfinite()) {
            return null;
        }
        if (this.isCalendrical()) {
            if (boundary.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary2 = this.intervals.get(i).getEnd();
                Object object2 = boundary2.getTemporal();
                if (boundary2.isInfinite()) {
                    return null;
                }
                if (boundary2.isOpen()) {
                    object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
                }
                if (!object2.isAfter(object)) continue;
                object = object2;
            }
        } else {
            Object var4_5 = null;
            if (boundary.isClosed()) {
                Temporal temporal = (Temporal)this.getTimeLine().stepForward(object);
                if (temporal == null) {
                    var4_5 = object;
                } else {
                    object = temporal;
                }
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary3 = this.intervals.get(i).getEnd();
                Object object3 = boundary3.getTemporal();
                if (boundary3.isInfinite()) {
                    return null;
                }
                if (var4_5 != null) continue;
                if (boundary3.isClosed()) {
                    Temporal temporal = (Temporal)this.getTimeLine().stepForward(object3);
                    if (temporal == null) {
                        var4_5 = object3;
                        continue;
                    }
                    object3 = temporal;
                }
                if (!object3.isAfter(object)) continue;
                object = object3;
            }
            object = var4_5 != null ? var4_5 : (Temporal)this.getTimeLine().stepBackwards(object);
        }
        return object;
    }

    public IntervalCollection<T> plus(ChronoInterval<T> chronoInterval) {
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        arrayList.add(this.adjust(chronoInterval));
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> plus(List<? extends ChronoInterval<T>> list) {
        if (list.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        for (ChronoInterval<T> chronoInterval : list) {
            arrayList.add(this.adjust(chronoInterval));
        }
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> minus(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return this;
        }
        ChronoInterval<T> chronoInterval2 = this.intervals.get(0);
        ChronoInterval<T> chronoInterval3 = this.adjust(chronoInterval);
        if (!chronoInterval2.getStart().isInfinite() && chronoInterval3.isBefore(chronoInterval2.getStart().getTemporal())) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        IntervalCollection<T> intervalCollection = this.create(Collections.singletonList(chronoInterval3));
        IntervalCollection<T> intervalCollection2 = intervalCollection.withComplement(chronoInterval2);
        if (!intervalCollection2.isEmpty()) {
            arrayList.addAll(intervalCollection2.intervals);
        }
        int n = this.intervals.size();
        for (int i = 1; i < n; ++i) {
            chronoInterval2 = this.intervals.get(i);
            if (!chronoInterval2.getStart().isInfinite() && chronoInterval3.isBefore(chronoInterval2.getStart().getTemporal())) {
                arrayList.add(chronoInterval2);
                for (int j = i + 1; j < n; ++j) {
                    arrayList.add(this.intervals.get(j));
                }
                break;
            }
            intervalCollection2 = intervalCollection.withComplement(chronoInterval2);
            if (intervalCollection2.isEmpty()) continue;
            arrayList.addAll(intervalCollection2.intervals);
        }
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> minus(List<? extends ChronoInterval<T>> list) {
        if (this.isEmpty() || list.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        ArrayList<ChronoInterval<T>> arrayList2 = new ArrayList<ChronoInterval<T>>();
        for (ChronoInterval<T> chronoInterval : list) {
            arrayList2.add(this.adjust(chronoInterval));
        }
        Collections.sort(arrayList2, this.getComparator());
        IntervalCollection<T> intervalCollection = this.create(arrayList2);
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            ChronoInterval<T> chronoInterval = this.intervals.get(i);
            IntervalCollection<T> intervalCollection2 = intervalCollection.withComplement(chronoInterval);
            if (intervalCollection2.isEmpty()) continue;
            arrayList.addAll(intervalCollection2.intervals);
        }
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> withTimeWindow(ChronoInterval<T> chronoInterval) {
        return this.withFilter(this.adjust(chronoInterval));
    }

    public IntervalCollection<T> withComplement(ChronoInterval<T> chronoInterval) {
        Temporal temporal;
        Object object;
        ChronoInterval<T> chronoInterval2 = this.adjust(chronoInterval);
        IntervalCollection<T> intervalCollection = this.withFilter(chronoInterval2);
        if (intervalCollection.isEmpty()) {
            return this.create(Collections.singletonList(chronoInterval2));
        }
        Boundary<T> boundary = chronoInterval2.getStart();
        Boundary<T> boundary2 = chronoInterval2.getEnd();
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        T t = intervalCollection.getMinimum();
        if (t != null) {
            if (boundary.isInfinite()) {
                this.addLeft(arrayList, t);
            } else {
                object = boundary.getTemporal();
                if (boundary.isOpen()) {
                    object = (Temporal)this.getTimeLine().stepBackwards(object);
                    if (object == null) {
                        this.addLeft(arrayList, t);
                    } else {
                        this.addLeft(arrayList, object, t);
                    }
                } else {
                    this.addLeft(arrayList, object, t);
                }
            }
        }
        arrayList.addAll(intervalCollection.withGaps().getIntervals());
        object = intervalCollection.getMaximum();
        if (object != null && (temporal = (Temporal)this.getTimeLine().stepForward(object)) != null) {
            Boundary<Temporal> boundary3 = Boundary.ofClosed(temporal);
            if (boundary2.isInfinite()) {
                Boundary<T> boundary4 = boundary2;
                arrayList.add(this.newInterval(boundary3, boundary4));
            } else if (this.isCalendrical()) {
                Boundary<T> boundary5;
                if (boundary2.isClosed()) {
                    boundary5 = boundary2;
                } else {
                    Object object2 = boundary2.getTemporal();
                    object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
                    boundary5 = Boundary.ofClosed(object2);
                }
                if (!temporal.isAfter(boundary5.getTemporal())) {
                    arrayList.add(this.newInterval(boundary3, boundary5));
                }
            } else {
                Boundary<T> boundary6;
                if (boundary2.isOpen()) {
                    boundary6 = boundary2;
                } else {
                    Object object3 = boundary2.getTemporal();
                    object3 = (Temporal)this.getTimeLine().stepForward(object3);
                    boundary6 = object3 == null ? Boundary.infiniteFuture() : Boundary.ofOpen(object3);
                }
                if (temporal.isBefore(boundary6.getTemporal())) {
                    arrayList.add(this.newInterval(boundary3, boundary6));
                }
            }
        }
        return this.create(arrayList);
    }

    public IntervalCollection<T> withGaps() {
        ChronoInterval<T> chronoInterval;
        int n = this.intervals.size();
        if (n == 0) {
            return this;
        }
        if (n == 1) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        Object var3_4 = null;
        int n2 = n - 1;
        for (int i = 0; i < n2 && !(chronoInterval = this.intervals.get(i)).getEnd().isInfinite(); ++i) {
            Object object = chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) break;
            if (var3_4 == null || object.isAfter(var3_4)) {
                var3_4 = object;
            } else {
                object = var3_4;
            }
            Object object2 = this.intervals.get(i + 1).getStart().getTemporal();
            if (object2 == null || !object2.isAfter(object)) continue;
            IntervalEdge intervalEdge = IntervalEdge.OPEN;
            if (this.isCalendrical()) {
                intervalEdge = IntervalEdge.CLOSED;
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
                if (object2 == null) continue;
            }
            Boundary<T> boundary = Boundary.ofClosed(object);
            Boundary<T> boundary2 = Boundary.of(intervalEdge, object2);
            arrayList.add(this.newInterval(boundary, boundary2));
        }
        return this.create(arrayList);
    }

    public IntervalCollection<T> withBlocks() {
        Boundary boundary;
        Boundary<T> boundary2;
        if (this.intervals.size() < 2) {
            return this;
        }
        boolean bl = this.isCalendrical();
        IntervalEdge intervalEdge = bl ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        List<ChronoInterval<T>> list = this.withGaps().intervals;
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        Object object = this.getMinimum();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = list.get(i).getStart().getTemporal();
            if (bl) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            boundary2 = this.createStartBoundary(object);
            boundary = Boundary.of(intervalEdge, object2);
            arrayList.add(this.newInterval(boundary2, boundary));
            Boundary<T> boundary3 = list.get(i).getEnd();
            object = boundary3.getTemporal();
            if (!boundary3.isClosed()) continue;
            object = (Temporal)this.getTimeLine().stepForward(object);
        }
        Object object3 = this.getMaximum();
        boundary2 = this.createStartBoundary(object);
        if (object3 != null && !bl) {
            object3 = (Temporal)this.getTimeLine().stepForward(object3);
        }
        boundary = object3 == null ? Boundary.infiniteFuture() : Boundary.of(intervalEdge, object3);
        arrayList.add(this.newInterval(boundary2, boundary));
        return this.create(arrayList);
    }

    /*
     * Exception decompiling
     */
    public IntervalCollection<T> withIntersection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IntervalCollection<T> union(IntervalCollection<T> intervalCollection) {
        if (this == intervalCollection) {
            return this;
        }
        return this.plus(intervalCollection.getIntervals());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntervalCollection) {
            IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(object);
            return this.getTimeLine().equals(intervalCollection.getTimeLine()) && this.intervals.equals(intervalCollection.intervals);
        }
        return false;
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }

    public String toString() {
        int n = this.intervals.size();
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        stringBuilder.append('{');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.intervals.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append('}').toString();
    }

    int getSize() {
        return this.intervals.size();
    }

    abstract Comparator<ChronoInterval<T>> getComparator();

    abstract IntervalCollection<T> create(List<ChronoInterval<T>> var1);

    abstract TimeLine<T> getTimeLine();

    abstract ChronoInterval<T> newInterval(Boundary<T> var1, Boundary<T> var2);

    boolean isCalendrical() {
        return false;
    }

    private ChronoInterval<T> adjust(ChronoInterval<T> chronoInterval) {
        Boundary<Object> boundary = chronoInterval.getStart();
        if (!boundary.isInfinite() && boundary.isOpen()) {
            Temporal temporal = (Temporal)this.getTimeLine().stepForward(boundary.getTemporal());
            if (temporal == null) {
                throw new IllegalArgumentException("Interval start with open maximum: " + chronoInterval);
            }
            boundary = Boundary.ofClosed(temporal);
            return this.newInterval(boundary, chronoInterval.getEnd());
        }
        return chronoInterval;
    }

    private IntervalCollection<T> withFilter(ChronoInterval<T> chronoInterval) {
        Boundary<T> boundary = chronoInterval.getStart();
        Boundary<T> boundary2 = chronoInterval.getEnd();
        if (this.isEmpty() || boundary.isInfinite() && boundary2.isInfinite()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        for (ChronoInterval<T> chronoInterval2 : this.intervals) {
            if (chronoInterval2.isFinite() && chronoInterval.contains(chronoInterval2.getStart().getTemporal()) && chronoInterval.contains(chronoInterval2.getEnd().getTemporal())) {
                arrayList.add(chronoInterval2);
                continue;
            }
            ArrayList<ChronoInterval<T>> arrayList2 = new ArrayList<ChronoInterval<T>>(2);
            arrayList2.add(chronoInterval);
            arrayList2.add(chronoInterval2);
            Collections.sort(arrayList2, this.getComparator());
            IntervalCollection<T> intervalCollection = this.create(arrayList2).withIntersection();
            if (intervalCollection.isEmpty()) continue;
            arrayList.add(intervalCollection.getIntervals().get(0));
        }
        return this.create(arrayList);
    }

    private Boundary<T> createStartBoundary(T t) {
        if (t == null) {
            return Boundary.infinitePast();
        }
        return Boundary.ofClosed(t);
    }

    private void addLeft(List<ChronoInterval<T>> list, T t) {
        Temporal temporal = (Temporal)this.getTimeLine().stepBackwards(t);
        if (temporal != null) {
            Boundary<Object> boundary = this.isCalendrical() ? Boundary.ofClosed(temporal) : Boundary.ofOpen(t);
            Boundary boundary2 = Boundary.infinitePast();
            list.add(this.newInterval(boundary2, boundary));
        }
    }

    private void addLeft(List<ChronoInterval<T>> list, T t, T t2) {
        if (t.isBefore(t2)) {
            Boundary<Object> boundary = this.isCalendrical() ? Boundary.ofClosed((Temporal)this.getTimeLine().stepBackwards(t2)) : Boundary.ofOpen(t2);
            Boundary<T> boundary2 = Boundary.ofClosed(t);
            list.add(this.newInterval(boundary2, boundary));
        }
    }
}

