/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.util.Comparator;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.range.ChronoInterval;

final class IntervalComparator<T extends Temporal<? super T>>
implements Comparator<ChronoInterval<T>> {
    private final boolean calendrical;
    private final TimeLine<T> axis;

    IntervalComparator(boolean bl, TimeLine<T> timeLine) {
        this.calendrical = bl;
        this.axis = timeLine;
    }

    @Override
    public int compare(ChronoInterval<T> chronoInterval, ChronoInterval<T> chronoInterval2) {
        T t;
        if (chronoInterval.getStart().isInfinite()) {
            if (chronoInterval2.getStart().isInfinite()) {
                return this.compareEnd(chronoInterval, chronoInterval2);
            }
            return -1;
        }
        if (chronoInterval2.getStart().isInfinite()) {
            return 1;
        }
        T t2 = chronoInterval.getStart().getTemporal();
        if (t2.isBefore(t = chronoInterval2.getStart().getTemporal())) {
            return -1;
        }
        if (t2.isAfter(t)) {
            return 1;
        }
        return this.compareEnd(chronoInterval, chronoInterval2);
    }

    private int compareEnd(ChronoInterval<T> chronoInterval, ChronoInterval<T> chronoInterval2) {
        if (chronoInterval.getEnd().isInfinite()) {
            if (chronoInterval2.getEnd().isInfinite()) {
                return 0;
            }
            return 1;
        }
        if (chronoInterval2.getEnd().isInfinite()) {
            return -1;
        }
        Object object = chronoInterval.getEnd().getTemporal();
        Object object2 = chronoInterval2.getEnd().getTemporal();
        if (this.calendrical) {
            if (chronoInterval.getEnd().isOpen()) {
                object = (Temporal)this.axis.stepBackwards(object);
            }
            if (chronoInterval2.getEnd().isOpen()) {
                object2 = (Temporal)this.axis.stepBackwards(object2);
            }
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
        } else {
            if (chronoInterval.getEnd().isClosed()) {
                object = (Temporal)this.axis.stepForward(object);
            }
            if (chronoInterval2.getEnd().isClosed()) {
                object2 = (Temporal)this.axis.stepForward(object2);
            }
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
        }
        if (object.isBefore(object2)) {
            return -1;
        }
        if (object.isAfter(object2)) {
            return 1;
        }
        return 0;
    }
}

