/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.time4j.AdjustableElement;
import net.time4j.Duration;
import net.time4j.PlainDate;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeSpan;
import net.time4j.format.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.DateInterval;
import net.time4j.range.IntervalFactory;

final class DateIntervalFactory
implements IntervalFactory<PlainDate, DateInterval> {
    private static final Set<ChronoElement<?>> CSET;
    private static final Set<ChronoElement<?>> OSET;
    private static final Set<ChronoElement<?>> WSET;
    static final DateIntervalFactory INSTANCE;

    private DateIntervalFactory() {
    }

    @Override
    public DateInterval between(Boundary<PlainDate> boundary, Boundary<PlainDate> boundary2) {
        return new DateInterval(boundary, boundary2);
    }

    @Override
    public PlainDate plusPeriod(PlainDate plainDate, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainDate)plainDate.plus((TimeSpan)Duration.parseCalendarPeriod((String)string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public PlainDate minusPeriod(PlainDate plainDate, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainDate)plainDate.minus((TimeSpan)Duration.parseCalendarPeriod((String)string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Set<ChronoElement<?>> stdElements(ChronoEntity<?> chronoEntity) {
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_MONTH)) {
            return CSET;
        }
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_YEAR)) {
            return OSET;
        }
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_WEEK)) {
            return WSET;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    static {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(PlainDate.YEAR);
        hashSet.add(PlainDate.MONTH_AS_NUMBER);
        CSET = Collections.unmodifiableSet(hashSet);
        HashSet<AdjustableElement> hashSet2 = new HashSet<AdjustableElement>();
        hashSet2.add(PlainDate.YEAR);
        OSET = Collections.unmodifiableSet(hashSet2);
        HashSet<AdjustableElement> hashSet3 = new HashSet<AdjustableElement>();
        hashSet3.add(PlainDate.YEAR_OF_WEEKDATE);
        hashSet3.add(Weekmodel.ISO.weekOfYear());
        WSET = Collections.unmodifiableSet(hashSet3);
        INSTANCE = new DateIntervalFactory();
    }
}

