/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.internal;

import java.util.Locale;

public class FormatUtils {
    private FormatUtils() {
    }

    public static String getRegion(Locale locale) {
        String string;
        String string2 = locale.getUnicodeLocaleType("rg");
        if (string2 != null && string2.length() == 6 && (string = string2.toUpperCase(Locale.US)).endsWith("ZZZZ")) {
            return string.substring(0, 2);
        }
        return locale.getCountry();
    }

    public static boolean useDefaultWeekmodel(Locale locale) {
        String string = locale.getUnicodeLocaleType("fw");
        if (string != null && FormatUtils.getWeekdayISO(string) != 0) {
            return false;
        }
        return FormatUtils.getRegion(locale).isEmpty();
    }

    private static int getWeekdayISO(String string) {
        switch (string) {
            case "mon": {
                return 1;
            }
            case "tue": {
                return 2;
            }
            case "wed": {
                return 3;
            }
            case "thu": {
                return 4;
            }
            case "fri": {
                return 5;
            }
            case "sat": {
                return 6;
            }
            case "sun": {
                return 7;
            }
        }
        return 0;
    }
}

