/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.ObjectStreamException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

final class PlatformTimezone
extends Timezone {
    private static final long serialVersionUID = -8432968264242113551L;
    private final TZID id;
    private final TimeZone tz;
    private final boolean strict;
    private final transient ZonalOffset fixedOffset;

    PlatformTimezone(TZID tZID, String string) {
        this(tZID, PlatformTimezone.findZone(string), false);
    }

    private PlatformTimezone(TZID tZID, TimeZone timeZone, boolean bl) {
        this.id = tZID;
        this.tz = (TimeZone)timeZone.clone();
        this.strict = bl;
        if (this.tz.useDaylightTime()) {
            this.fixedOffset = null;
        } else {
            String string = this.tz.getID();
            boolean bl2 = string.startsWith("GMT") || string.startsWith("Etc/") || string.equals("Greenwich") || string.equals("UCT") || string.equals("UTC") || string.equals("Universal") || string.equals("Zulu");
            this.fixedOffset = bl2 ? PlatformTimezone.fromOffsetMillis(this.tz.getOffset(System.currentTimeMillis())) : null;
        }
    }

    @Override
    public TZID getID() {
        return this.id;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        if (this.isFixed()) {
            return this.fixedOffset;
        }
        return PlatformTimezone.fromOffsetMillis(this.tz.getOffset(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        int n;
        int n2;
        if (this.isFixed()) {
            return this.fixedOffset;
        }
        int n3 = gregorianDate.getYear();
        int n4 = gregorianDate.getMonth();
        int n5 = gregorianDate.getDayOfMonth();
        if (wallTime.getHour() == 24) {
            long l = MathUtils.safeAdd(GregorianMath.toMJD(gregorianDate), 1L);
            long l2 = GregorianMath.toPackedDate(l);
            n3 = GregorianMath.readYear(l2);
            n4 = GregorianMath.readMonth(l2);
            n5 = GregorianMath.readDayOfMonth(l2);
        }
        if (n3 > 0) {
            n2 = 1;
            n = n3;
        } else {
            n2 = 0;
            n = 1 - n3;
        }
        int n6 = GregorianMath.getDayOfWeek(n3, n4, n5) + 1;
        if (n6 == 8) {
            n6 = 1;
        }
        int n7 = wallTime.getHour() == 24 ? 0 : (wallTime.getHour() * 3600 + wallTime.getMinute() * 60 + wallTime.getSecond()) * 1000 + wallTime.getNanosecond() / 1000000;
        return PlatformTimezone.fromOffsetMillis(this.tz.getOffset(n2, n, n4 - 1, n5, n6, n7));
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        if (this.isFixed()) {
            return false;
        }
        int n = gregorianDate.getYear();
        int n2 = gregorianDate.getMonth();
        int n3 = gregorianDate.getDayOfMonth();
        int n4 = wallTime.getHour();
        int n5 = wallTime.getMinute();
        int n6 = wallTime.getSecond();
        int n7 = wallTime.getNanosecond() / 1000000;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.tz);
        gregorianCalendar.set(14, n7);
        gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
        return gregorianCalendar.get(1) != n || gregorianCalendar.get(2) + 1 != n2 || gregorianCalendar.get(5) != n3 || gregorianCalendar.get(11) != n4 || gregorianCalendar.get(12) != n5 || gregorianCalendar.get(13) != n6 || gregorianCalendar.get(14) != n7;
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        if (this.isFixed()) {
            return false;
        }
        return this.tz.inDaylightTime(new Date(unixTime.getPosixTime() * 1000L));
    }

    @Override
    public boolean isFixed() {
        return this.fixedOffset != null;
    }

    @Override
    public TransitionHistory getHistory() {
        return this.fixedOffset == null ? null : this.fixedOffset.getModel();
    }

    public boolean equals(Object object) {
        if (object instanceof PlatformTimezone) {
            PlatformTimezone platformTimezone = (PlatformTimezone)object;
            if (!this.tz.equals(platformTimezone.tz)) {
                return false;
            }
            if (this.fixedOffset == null) {
                return platformTimezone.fixedOffset == null;
            }
            return this.fixedOffset.equals(platformTimezone.fixedOffset);
        }
        return false;
    }

    public int hashCode() {
        return this.tz.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(this.tz);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        return this.tz.getDisplayName(nameStyle.isDaylightSaving(), nameStyle.isAbbreviation() ? 0 : 1, locale);
    }

    @Override
    public TransitionStrategy getStrategy() {
        return this.strict ? STRICT_MODE : DEFAULT_CONFLICT_STRATEGY;
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        if (this.getStrategy() == transitionStrategy) {
            return this;
        }
        if (transitionStrategy == DEFAULT_CONFLICT_STRATEGY) {
            return new PlatformTimezone(this.id, this.tz, false);
        }
        if (transitionStrategy == STRICT_MODE) {
            return new PlatformTimezone(this.id, this.tz, true);
        }
        throw new UnsupportedOperationException(transitionStrategy.toString());
    }

    static TimeZone findZone(String string) {
        if (string.equals("Z")) {
            return TimeZone.getTimeZone("GMT+00:00");
        }
        if (string.startsWith("UTC")) {
            return TimeZone.getTimeZone("GMT" + string.substring(3));
        }
        if (string.startsWith("UT")) {
            return TimeZone.getTimeZone("GMT" + string.substring(2));
        }
        return TimeZone.getTimeZone(string);
    }

    boolean isGMT() {
        return this.tz.getID().equals("GMT");
    }

    private static ZonalOffset fromOffsetMillis(int n) {
        return ZonalOffset.ofTotalSeconds(MathUtils.floorDivide(n, 1000));
    }

    private Object readResolve() throws ObjectStreamException {
        return new PlatformTimezone(this.id, this.tz, this.strict);
    }
}

