/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.Leniency;
import net.time4j.format.NumericalElement;
import net.time4j.format.ParseLog;
import net.time4j.format.SignPolicy;

final class NumberProcessor<V>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final boolean fixedWidth;
    private final int minDigits;
    private final int maxDigits;
    private final SignPolicy signPolicy;

    NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy) {
        this.element = chronoElement;
        this.fixedWidth = bl;
        this.minDigits = n;
        this.maxDigits = n2;
        this.signPolicy = signPolicy;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (signPolicy == null) {
            throw new NullPointerException("Missing sign policy.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Not positive: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Max smaller than min: " + n2 + " < " + n);
        }
        if (bl && n != n2) {
            throw new IllegalArgumentException("Variable width in fixed-width-mode: " + n2 + " != " + n);
        }
        if (bl && signPolicy != SignPolicy.SHOW_NEVER) {
            throw new IllegalArgumentException("Sign policy must be SHOW_NEVER in fixed-width-mode.");
        }
        int n3 = this.getScale();
        if (n > n3) {
            throw new IllegalArgumentException("Min digits out of range: " + n);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Max digits out of range: " + n2);
        }
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        int n;
        int n2;
        int n3;
        Class<V> clazz = this.element.getType();
        V v = chronoDisplay.get(this.element);
        boolean bl = false;
        String string = "";
        if (clazz == Integer.class) {
            n3 = (Integer)Integer.class.cast(v);
            bl = n3 < 0;
            string = n3 == Integer.MIN_VALUE ? "2147483648" : Integer.toString(Math.abs(n3));
        } else if (clazz == Long.class) {
            long l = (Long)Long.class.cast(v);
            bl = l < 0L;
            string = l == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l));
        } else if (Enum.class.isAssignableFrom(clazz)) {
            int n4 = -1;
            if (this.element instanceof NumericalElement) {
                n4 = ((NumericalElement)this.element).numerical(v);
                bl = n4 < 0;
            } else {
                V[] VArray = clazz.getEnumConstants();
                n2 = VArray.length;
                for (n = 0; n < n2; ++n) {
                    V v2 = VArray[n];
                    if (!v2.equals(v)) continue;
                    n4 = ((Enum)Enum.class.cast(v2)).ordinal();
                    break;
                }
                if (n4 == -1) {
                    throw new AssertionError((Object)("Enum broken: " + v + " / " + clazz.getName()));
                }
            }
            string = n4 == Integer.MIN_VALUE ? "2147483648" : Integer.toString(Math.abs(n4));
        } else {
            throw new IllegalArgumentException("Not formattable: " + this.element);
        }
        if (string.length() > this.maxDigits) {
            throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the value " + v + " exceeds the maximum width of " + this.maxDigits + ".");
        }
        n3 = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        if (n3 != 48) {
            int n5 = n3 - 48;
            char[] cArray = string.toCharArray();
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = (char)(cArray[n] + n5);
            }
            string = new String(cArray);
        }
        int n6 = -1;
        n2 = 0;
        if (appendable instanceof CharSequence) {
            n6 = ((CharSequence)((Object)appendable)).length();
        }
        if (bl) {
            if (this.signPolicy == SignPolicy.SHOW_NEVER) {
                throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
            }
            appendable.append('-');
            ++n2;
        } else {
            switch (this.signPolicy) {
                case SHOW_ALWAYS: {
                    appendable.append('+');
                    ++n2;
                    break;
                }
                case SHOW_WHEN_BIG_NUMBER: {
                    if (string.length() <= this.minDigits) break;
                    appendable.append('+');
                    ++n2;
                    break;
                }
            }
        }
        int n7 = this.minDigits - string.length();
        for (n = 0; n < n7; ++n) {
            appendable.append((char)n3);
            ++n2;
        }
        appendable.append(string);
        if (n6 != -1 && (n2 += string.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n6, n6 + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        int n2;
        int n3;
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        int n4 = 1;
        int n5 = this.getScale();
        if (this.fixedWidth || !leniency.isLax()) {
            n4 = this.minDigits;
            n5 = this.maxDigits;
        }
        int n6 = charSequence.length();
        int n7 = n3 = parseLog.getPosition();
        int n8 = formatStep.getAttribute(Attributes.PROTECTED_CHARACTERS, attributeQuery, 0);
        if (n8 > 0) {
            n6 -= n8;
        }
        if (n7 >= n6) {
            parseLog.setError(n7, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        boolean bl = false;
        char c = charSequence.charAt(n7);
        if (c == '-' || c == '+') {
            if (this.signPolicy == SignPolicy.SHOW_NEVER && (this.fixedWidth || leniency.isStrict())) {
                parseLog.setError(n3, "Sign not allowed due to sign policy.");
                return;
            }
            if (this.signPolicy == SignPolicy.SHOW_WHEN_NEGATIVE && c == '+' && leniency.isStrict()) {
                parseLog.setError(n3, "Positive sign not allowed due to sign policy.");
                return;
            }
            bl = c == '-';
            ++n7;
            ++n3;
        } else if (this.signPolicy == SignPolicy.SHOW_ALWAYS && leniency.isStrict()) {
            parseLog.setError(n3, "Missing sign of number.");
            return;
        }
        if (n7 >= n6) {
            parseLog.setError(n3, "Missing digits for: " + this.element.name());
            return;
        }
        char c2 = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n9 = formatStep.getReserved();
        if (!this.fixedWidth && n9 > 0 && n8 <= 0) {
            int n10;
            n2 = 0;
            for (n = n7; n < n6 && (n10 = charSequence.charAt(n) - c2) >= 0 && n10 <= 9; ++n) {
                ++n2;
            }
            n5 = Math.min(n5, n2 - n9);
        }
        n2 = n7 + n4;
        n = Math.min(n6, n7 + n5);
        long l = 0L;
        boolean bl2 = true;
        while (n7 < n) {
            int n11 = charSequence.charAt(n7) - c2;
            if (n11 >= 0 && n11 <= 9) {
                l = l * 10L + (long)n11;
                ++n7;
                bl2 = false;
                continue;
            }
            if (!bl2) break;
            parseLog.setError(n3, "Digit expected.");
            return;
        }
        if (n7 < n2 && (bl2 || this.fixedWidth || !leniency.isLax())) {
            parseLog.setError(n3, "Not enough digits found for: " + this.element.name());
            return;
        }
        if (bl) {
            if (l == 0L && leniency.isStrict()) {
                parseLog.setError(n3 - 1, "Negative zero is not allowed.");
                return;
            }
            l = -l;
        } else if (this.signPolicy == SignPolicy.SHOW_WHEN_BIG_NUMBER && leniency.isStrict()) {
            if (c == '+' && n7 <= n2) {
                parseLog.setError(n3 - 1, "Positive sign only allowed for big number.");
            } else if (c != '+' && n7 > n2) {
                parseLog.setError(n3, "Positive sign must be present for big number.");
            }
        }
        Number number = null;
        Class<V> clazz = this.element.getType();
        if (clazz == Integer.class) {
            number = (int)l;
        } else if (clazz == Long.class) {
            number = l;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            if (this.element instanceof NumericalElement) {
                NumericalElement numericalElement = (NumericalElement)this.element;
                for (V v : clazz.getEnumConstants()) {
                    if ((long)numericalElement.numerical(clazz.cast(v)) != l) continue;
                    number = v;
                    break;
                }
            } else {
                for (V v : clazz.getEnumConstants()) {
                    if ((long)((Enum)Enum.class.cast(v)).ordinal() != l) continue;
                    number = v;
                    break;
                }
            }
            if (number == null) {
                parseLog.setError(c == '-' || c == '+' ? n3 - 1 : n3, "[" + this.element.name() + "] No enum found for value: " + l);
                return;
            }
        } else {
            throw new IllegalArgumentException("Not parseable: " + this.element);
        }
        map.put(this.element, number);
        parseLog.setPosition(n7);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NumberProcessor) {
            NumberProcessor numberProcessor = (NumberProcessor)object;
            return this.element.equals(numberProcessor.element) && this.fixedWidth == numberProcessor.fixedWidth && this.minDigits == numberProcessor.minDigits && this.maxDigits == numberProcessor.maxDigits && this.signPolicy == numberProcessor.signPolicy;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", fixed-width-mode=");
        stringBuilder.append(this.fixedWidth);
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(", sign-policy=");
        stringBuilder.append((Object)this.signPolicy);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new NumberProcessor<V>(chronoElement, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    private int getScale() {
        return this.element.getType() == Long.class ? 18 : 9;
    }
}

