/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.ValidationElement;
import net.time4j.format.AmbivalentValueException;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.ChronoParser;
import net.time4j.format.ChronoPattern;
import net.time4j.format.ChronoPrinter;
import net.time4j.format.CustomizedProcessor;
import net.time4j.format.DecimalProcessor;
import net.time4j.format.DisplayMode;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.FractionProcessor;
import net.time4j.format.IgnorableWhitespaceProcessor;
import net.time4j.format.Leniency;
import net.time4j.format.LiteralProcessor;
import net.time4j.format.LocalizedGMTProcessor;
import net.time4j.format.LookupProcessor;
import net.time4j.format.NonAmbivalentMap;
import net.time4j.format.NumberProcessor;
import net.time4j.format.OrdinalProcessor;
import net.time4j.format.ParseLog;
import net.time4j.format.ParsedValues;
import net.time4j.format.PluralCategory;
import net.time4j.format.SignPolicy;
import net.time4j.format.TextElement;
import net.time4j.format.TextProcessor;
import net.time4j.format.TimezoneIDProcessor;
import net.time4j.format.TimezoneNameProcessor;
import net.time4j.format.TimezoneOffsetProcessor;
import net.time4j.format.TwoDigitYearProcessor;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ChronoFormatter<T extends ChronoEntity<T>>
implements ChronoPrinter<T>,
ChronoParser<T> {
    private static final Integer ZERO = 0;
    private final Chronology<T> chronology;
    private final Attributes defaultAttributes;
    private final List<FormatStep> steps;
    private final Map<ChronoElement<?>, Object> defaults;
    private final FractionProcessor fracproc;

    private ChronoFormatter(Chronology<T> chronology, Locale locale, List<FormatStep> list) {
        if (chronology == null) {
            throw new NullPointerException("Missing chronology.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No format processors defined.");
        }
        this.chronology = chronology;
        this.defaultAttributes = Attributes.createDefaults(locale).setCalendarType(CalendarText.extractCalendarType(chronology)).build();
        this.steps = Collections.unmodifiableList(list);
        this.defaults = Collections.emptyMap();
        FractionProcessor fractionProcessor = null;
        for (FormatStep formatStep : this.steps) {
            if (!(formatStep.getProcessor() instanceof FractionProcessor)) continue;
            fractionProcessor = (FractionProcessor)FractionProcessor.class.cast(formatStep.getProcessor());
            break;
        }
        this.fracproc = fractionProcessor;
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, Attributes attributes) {
        if (attributes == null) {
            throw new NullPointerException("Missing default attributes.");
        }
        this.chronology = chronoFormatter.chronology;
        this.defaultAttributes = attributes;
        this.defaults = Collections.unmodifiableMap(new NonAmbivalentMap((Map<? extends ChronoElement<?>, ? extends Object>)chronoFormatter.defaults));
        this.fracproc = chronoFormatter.fracproc;
        int n = chronoFormatter.steps.size();
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        block0: for (int i = 0; i < n; ++i) {
            FormatStep formatStep = (FormatStep)arrayList.get(i);
            ChronoElement<?> chronoElement = formatStep.getProcessor().getElement();
            if (chronoElement == null || this.chronology.isRegistered(chronoElement)) continue;
            boolean bl = false;
            for (ChronoExtension chronoExtension : this.chronology.getExtensions()) {
                Set<ChronoElement<?>> set = chronoExtension.getElements(attributes.getLocale(), attributes);
                for (ChronoElement<?> chronoElement2 : set) {
                    if (!chronoElement2.name().equals(chronoElement.name())) continue;
                    if (chronoElement2 != chronoElement) {
                        arrayList.set(i, formatStep.updateElement(chronoElement2));
                    }
                    bl = true;
                    break;
                }
                if (!bl) continue;
                continue block0;
            }
        }
        this.steps = Collections.unmodifiableList(arrayList);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, ChronoElement<?> chronoElement, Object object) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        ChronoFormatter.checkElement(chronoFormatter.chronology, chronoElement);
        this.chronology = chronoFormatter.chronology;
        this.defaultAttributes = chronoFormatter.defaultAttributes;
        this.fracproc = chronoFormatter.fracproc;
        NonAmbivalentMap nonAmbivalentMap = new NonAmbivalentMap((Map<? extends ChronoElement<?>, ? extends Object>)chronoFormatter.defaults);
        if (object == null) {
            nonAmbivalentMap.remove(chronoElement);
        } else {
            nonAmbivalentMap.put(chronoElement, object);
        }
        this.defaults = Collections.unmodifiableMap(nonAmbivalentMap);
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        this.steps = Collections.unmodifiableList(arrayList);
    }

    public Chronology<T> getChronology() {
        return this.chronology;
    }

    public Locale getLocale() {
        return this.getDefaultAttributes().getLocale();
    }

    public Attributes getDefaultAttributes() {
        return this.defaultAttributes;
    }

    public String format(T t) {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, (AttributeQuery)this.defaultAttributes);
        StringBuilder stringBuilder = new StringBuilder(this.steps.size() * 8);
        try {
            this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.defaultAttributes, false);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringBuilder.toString();
    }

    public Set<ElementPosition> print(T t, StringBuilder stringBuilder) {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, (AttributeQuery)this.defaultAttributes);
        try {
            return this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.defaultAttributes, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public Set<ElementPosition> print(T t, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, attributeQuery);
        return this.print(chronoDisplay, appendable, attributeQuery, true);
    }

    @Override
    public <R> R print(T t, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
        ChronoDisplay chronoDisplay = this.chronology.preformat(t, attributeQuery);
        this.print(chronoDisplay, appendable, attributeQuery, false);
        return chronoFunction.apply(chronoDisplay);
    }

    private Set<ElementPosition> print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("Missing text result buffer.");
        }
        LinkedHashSet<ElementPosition> linkedHashSet = null;
        if (bl) {
            linkedHashSet = new LinkedHashSet<ElementPosition>(this.steps.size());
        }
        try {
            for (FormatStep formatStep : this.steps) {
                formatStep.print(chronoDisplay, appendable, attributeQuery, linkedHashSet);
            }
        }
        catch (ChronoException chronoException) {
            throw new IllegalArgumentException("Not formattable: " + chronoDisplay, chronoException);
        }
        if (bl) {
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.emptySet();
    }

    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        Object object = this.parse(charSequence, parseLog, this.defaultAttributes);
        if (object == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return (T)object;
    }

    public T parse(CharSequence charSequence, ParseLog parseLog) {
        return (T)this.parse(charSequence, parseLog, this.defaultAttributes);
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        Object object = null;
        Chronology<?> chronology = this.chronology.preparser();
        if (chronology == null) {
            return ChronoFormatter.parse(this, this.chronology, charSequence, parseLog, attributeQuery, false);
        }
        Object obj = ChronoFormatter.parse(this, chronology, charSequence, parseLog, attributeQuery, true);
        if (obj == null || parseLog.isError()) {
            return null;
        }
        ParsedValues parsedValues = parseLog.getRawValues0();
        try {
            object = this.chronology.createFrom((ChronoEntity)parsedValues, attributeQuery, false);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(parsedValues.toMap()));
            return null;
        }
        if (object == null) {
            if (!parseLog.isError()) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription(parsedValues.toMap()));
            }
            return null;
        }
        return (T)ChronoFormatter.checkConsistency(parsedValues, object, charSequence, parseLog, attributeQuery);
    }

    public ChronoEntity<?> parseRaw(String string) {
        return this.parseRaw(string, 0);
    }

    public ChronoEntity<?> parseRaw(CharSequence charSequence, int n) {
        ParsedValues parsedValues;
        Attributes attributes;
        ParseLog parseLog;
        block8: {
            if (n >= charSequence.length()) {
                return new ParsedValues();
            }
            parseLog = new ParseLog(n);
            attributes = this.defaultAttributes;
            Chronology<Object> chronology = this.chronology.preparser();
            if (chronology == null) {
                chronology = this.chronology;
            }
            LinkedList<NonAmbivalentMap> linkedList = new LinkedList<NonAmbivalentMap>();
            parsedValues = parseLog.getRawValues0();
            try {
                parsedValues = this.parseElements(charSequence, parseLog, attributes, linkedList);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block8;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parseLog.isError()) {
            return new ParsedValues();
        }
        assert (parsedValues != null);
        for (ChronoElement<?> object : this.defaults.keySet()) {
            if (parsedValues.contains(object)) continue;
            ChronoFormatter.fill(parsedValues, object, this.defaults.get(object));
        }
        for (ChronoExtension chronoExtension : this.chronology.getExtensions()) {
            if (chronoExtension.getElements(this.getLocale(), attributes).isEmpty()) continue;
            parsedValues = chronoExtension.resolve(parsedValues);
        }
        return parsedValues;
    }

    public ChronoFormatter<T> with(Locale locale) {
        if (locale.equals(this.defaultAttributes.getLocale())) {
            return this;
        }
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).setLocale(locale).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withTimezone(TZID tZID) {
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).setTimezone(tZID).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withTimezone(String string) {
        return this.withTimezone(Timezone.of(string).getID());
    }

    public ChronoFormatter<T> withStdTimezone() {
        return this.withTimezone(Timezone.ofSystem().getID());
    }

    public <V> ChronoFormatter<T> withDefault(ChronoElement<V> chronoElement, V v) {
        return new ChronoFormatter<T>(this, chronoElement, v);
    }

    public ChronoFormatter<T> with(AttributeKey<Boolean> attributeKey, boolean bl) {
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).set(attributeKey, bl).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Integer> attributeKey, int n) {
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).set(attributeKey, n).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Character> attributeKey, char c) {
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).set(attributeKey, c).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public <A extends Enum<A>> ChronoFormatter<T> with(AttributeKey<A> attributeKey, A a) {
        Attributes attributes = new Attributes.Builder().setAll(this.defaultAttributes).set(attributeKey, a).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(Attributes attributes) {
        Attributes attributes2 = new Attributes.Builder().setAll(this.defaultAttributes).setAll(attributes).build();
        return new ChronoFormatter<T>(this, attributes2);
    }

    public Format toFormat() {
        return new TraditionalFormat(this);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, Locale locale) {
        return new Builder(clazz, locale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)object;
            return this.chronology.equals(chronoFormatter.chronology) && this.defaultAttributes.equals(chronoFormatter.defaultAttributes) && this.defaults.equals(chronoFormatter.defaults) && this.steps.equals(chronoFormatter.steps);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.chronology.hashCode() + 31 * this.defaultAttributes.hashCode() + 37 * this.steps.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("net.time4j.format.ChronoFormatter[chronology=");
        stringBuilder.append(this.chronology.getChronoType().getName());
        stringBuilder.append(", default-attributes=");
        stringBuilder.append(this.defaultAttributes);
        stringBuilder.append(", default-values=");
        stringBuilder.append(this.defaults);
        stringBuilder.append(", processors=");
        boolean bl = true;
        for (FormatStep formatStep : this.steps) {
            if (bl) {
                bl = false;
                stringBuilder.append('{');
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append(formatStep);
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static <T extends ChronoEntity<T>> T parse(ChronoFormatter<?> chronoFormatter, Chronology<T> chronology, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl) {
        ParsedValues parsedValues;
        LinkedList<NonAmbivalentMap> linkedList;
        block13: {
            if (parseLog.getPosition() >= charSequence.length()) {
                throw new IndexOutOfBoundsException("[" + parseLog.getPosition() + "]: " + charSequence.toString());
            }
            linkedList = new LinkedList<NonAmbivalentMap>();
            parsedValues = parseLog.getRawValues0();
            try {
                parsedValues = super.parseElements(charSequence, parseLog, attributeQuery, linkedList);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block13;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parseLog.isError()) {
            return null;
        }
        int n = parseLog.getPosition();
        assert (parsedValues != null);
        if (n < charSequence.length() && !attributeQuery.get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            parseLog.setError(n, "Unparsed trailing characters: " + ChronoFormatter.sub(n, charSequence));
            return null;
        }
        for (ChronoElement<?> object2 : chronoFormatter.defaults.keySet()) {
            if (parsedValues.contains(object2)) continue;
            ChronoFormatter.fill(parsedValues, object2, chronoFormatter.defaults.get(object2));
        }
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            if (chronoExtension.getElements(chronoFormatter.getLocale(), attributeQuery).isEmpty()) continue;
            parsedValues = chronoExtension.resolve(parsedValues);
        }
        Object object = null;
        try {
            object = chronology.createFrom((ChronoEntity)parsedValues, attributeQuery, bl);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription((Map)linkedList.peek()));
            return null;
        }
        if (chronoFormatter.fracproc != null && object != null) {
            object = chronoFormatter.fracproc.update(object, parsedValues);
        }
        if (bl && object != null && chronology instanceof TimeAxis) {
            ChronoElement chronoElement = ((TimeAxis)TimeAxis.class.cast(chronology)).element();
            ChronoFormatter.updateSelf(parsedValues, chronoElement, object);
        }
        if (object == null) {
            parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription((Map)linkedList.peek()));
            return null;
        }
        return (T)ChronoFormatter.checkConsistency(parsedValues, object, charSequence, parseLog, attributeQuery);
    }

    private static String getReason(ParsedValues parsedValues) {
        String string;
        if (parsedValues.contains(ValidationElement.ERROR_MESSAGE)) {
            string = "Validation failed => " + parsedValues.get(ValidationElement.ERROR_MESSAGE);
            parsedValues.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)null);
        } else {
            string = "Insufficient data:";
        }
        return string;
    }

    private static <T> void updateSelf(ParsedValues parsedValues, ChronoElement<T> chronoElement, Object object) {
        parsedValues.with((ChronoElement)chronoElement, chronoElement.getType().cast(object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends ChronoEntity<T>> T checkConsistency(ParsedValues parsedValues, T t, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        if (!leniency.isStrict()) return t;
        if (t instanceof UnixTime) {
            if (parseLog.getDSTInfo() == null) return t;
            TZID tZID = parsedValues.getTimezone();
            UnixTime unixTime = (UnixTime)UnixTime.class.cast(t);
            try {
                boolean bl = Timezone.of(tZID).isDaylightSaving(unixTime);
                if (bl == parseLog.getDSTInfo()) return t;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Parsed entity is ");
                if (!bl) {
                    stringBuilder.append("not ");
                }
                stringBuilder.append("daylight-saving, but timezone name");
                stringBuilder.append(" has not the appropriate form in {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                t = null;
                return t;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Unable to check timezone name: ");
                stringBuilder.append(illegalArgumentException.getMessage());
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        } else {
            for (ChronoElement<?> chronoElement : parsedValues.toMap().keySet()) {
                Object obj = parsedValues.get(chronoElement);
                if (!t.contains(chronoElement) || t.get(chronoElement).equals(obj)) continue;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Text {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("} with element ");
                stringBuilder.append(chronoElement.name());
                stringBuilder.append(" {");
                stringBuilder.append(obj);
                stringBuilder.append("}, but parsed entity ");
                stringBuilder.append("has element value {");
                stringBuilder.append(t.get(chronoElement));
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        }
        return t;
    }

    private ParsedValues parseElements(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Deque<NonAmbivalentMap> deque) {
        NonAmbivalentMap nonAmbivalentMap = new NonAmbivalentMap();
        nonAmbivalentMap.put(null, (Object)parseLog.getPosition());
        deque.push(nonAmbivalentMap);
        int n = 0;
        int n2 = 0;
        int n3 = this.steps.size();
        for (int i = 0; i < n3; ++i) {
            ChronoElement<?> chronoElement;
            int n4;
            FormatStep formatStep = this.steps.get(i);
            for (n4 = n2 = formatStep.getLevel(); n4 > n; --n4) {
                nonAmbivalentMap = new NonAmbivalentMap();
                nonAmbivalentMap.put(null, (Object)parseLog.getPosition());
                deque.push(nonAmbivalentMap);
            }
            while (n4 < n) {
                nonAmbivalentMap = deque.pop();
                nonAmbivalentMap.remove(null);
                deque.peek().putAll(nonAmbivalentMap);
                ++n4;
            }
            Map map = deque.peek();
            parseLog.clearWarning();
            formatStep.parse(charSequence, parseLog, attributeQuery, map);
            if (parseLog.isWarning() && (chronoElement = formatStep.getProcessor().getElement()) != null && this.defaults.containsKey(chronoElement)) {
                map.put(chronoElement, this.defaults.get(chronoElement));
                parseLog.clearError();
                parseLog.clearWarning();
            }
            if (parseLog.isError()) {
                if (n2 == 0) {
                    nonAmbivalentMap = deque.peek();
                    nonAmbivalentMap.remove(null);
                    return new ParsedValues(nonAmbivalentMap);
                }
                int n5 = formatStep.getSection();
                int n6 = i;
                for (int j = n3 - 1; j > i; --j) {
                    if (this.steps.get(j).getSection() != n5) continue;
                    n6 = j;
                    break;
                }
                i = n6;
                nonAmbivalentMap = deque.pop();
                parseLog.clearError();
                parseLog.setPosition((Integer)nonAmbivalentMap.get(null));
            }
            n = --n2;
        }
        while (n2 > 0) {
            nonAmbivalentMap = deque.pop();
            nonAmbivalentMap.remove(null);
            deque.peek().putAll(nonAmbivalentMap);
            --n2;
        }
        nonAmbivalentMap = deque.peek();
        nonAmbivalentMap.remove(null);
        return new ParsedValues(nonAmbivalentMap);
    }

    private static String sub(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 - n <= 10) {
            return charSequence.subSequence(n, n2).toString();
        }
        return charSequence.subSequence(n, n + 10).toString() + "...";
    }

    private static String getDescription(Map<ChronoElement<?>, Object> map) {
        StringBuilder stringBuilder = new StringBuilder(map.size() * 16);
        stringBuilder.append(" [parsed={");
        boolean bl = true;
        for (ChronoElement<?> chronoElement : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(map.get(chronoElement));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static <V> void fill(ChronoEntity<?> chronoEntity, ChronoElement<V> chronoElement, Object object) {
        chronoEntity.with(chronoElement, chronoElement.getType().cast(object));
    }

    private static void checkElement(Chronology<?> chronology, ChronoElement<?> chronoElement) {
        Chronology<?> chronology2;
        if (!(chronology.isSupported(chronoElement) || (chronology2 = chronology.preparser()) != null && chronology2.isSupported(chronoElement))) {
            throw new IllegalArgumentException("Unsupported element: " + chronoElement.name());
        }
    }

    private static class TraditionalFormat<T extends ChronoEntity<T>>
    extends Format {
        private static final Map<String, DateFormat.Field> FIELD_MAP;
        private final ChronoFormatter<T> formatter;

        TraditionalFormat(ChronoFormatter<T> chronoFormatter) {
            this.formatter = chronoFormatter;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
            try {
                Attributes attributes = this.formatter.getDefaultAttributes();
                String string = attributes.get(Attributes.CALENDAR_TYPE, "iso8601");
                ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuffer, attributes);
                if (string.equals("iso8601")) {
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null || !field.equals(fieldPosition.getFieldAttribute()) && field.getCalendarField() != fieldPosition.getField()) continue;
                        fieldPosition.setBeginIndex(elementPosition.getStartIndex());
                        fieldPosition.setEndIndex(elementPosition.getEndIndex());
                        break;
                    }
                }
                return stringBuffer;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Not formattable: " + object, classCastException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot print object: " + object, iOException);
            }
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object object) {
            String string = this.formatter.getDefaultAttributes().get(Attributes.CALENDAR_TYPE, "iso8601");
            if (string.equals("iso8601")) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                    Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuilder);
                    AttributedString attributedString = new AttributedString(stringBuilder.toString());
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null) continue;
                        attributedString.addAttribute(field, field, elementPosition.getStartIndex(), elementPosition.getEndIndex());
                    }
                    return attributedString.getIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Not formattable: " + object, classCastException);
                }
            }
            return super.formatToCharacterIterator(object);
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            ParseLog parseLog = new ParseLog(parsePosition.getIndex());
            T t = this.formatter.parse(string, parseLog);
            if (t == null) {
                parsePosition.setErrorIndex(parseLog.getErrorIndex());
            } else {
                parsePosition.setIndex(parseLog.getPosition());
            }
            return t;
        }

        private static DateFormat.Field toField(ChronoElement<?> chronoElement) {
            return FIELD_MAP.get(chronoElement.name());
        }

        static {
            HashMap<String, DateFormat.Field> hashMap = new HashMap<String, DateFormat.Field>();
            hashMap.put("YEAR", DateFormat.Field.YEAR);
            hashMap.put("WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("BOUNDED_WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("BOUNDED_WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("MONTH_OF_YEAR", DateFormat.Field.MONTH);
            hashMap.put("MONTH_AS_NUMBER", DateFormat.Field.MONTH);
            hashMap.put("WEEKDAY_IN_MONTH", DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
            hashMap.put("SECOND_OF_MINUTE", DateFormat.Field.SECOND);
            hashMap.put("MINUTE_OF_HOUR", DateFormat.Field.MINUTE);
            hashMap.put("MILLI_OF_SECOND", DateFormat.Field.MILLISECOND);
            hashMap.put("DIGITAL_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY0);
            hashMap.put("DIGITAL_HOUR_OF_AMPM", DateFormat.Field.HOUR0);
            hashMap.put("CLOCK_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY1);
            hashMap.put("CLOCK_HOUR_OF_AMPM", DateFormat.Field.HOUR1);
            hashMap.put("AM_PM_OF_DAY", DateFormat.Field.AM_PM);
            hashMap.put("DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("LOCAL_DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("DAY_OF_YEAR", DateFormat.Field.DAY_OF_YEAR);
            hashMap.put("TIMEZONE_ID", DateFormat.Field.TIME_ZONE);
            FIELD_MAP = Collections.unmodifiableMap(hashMap);
        }
    }

    public static final class Builder<T extends ChronoEntity<T>> {
        private final Chronology<T> chronology;
        private final Locale locale;
        private List<FormatStep> steps;
        private LinkedList<Attributes> stack;
        private int sectionID;
        private int reservedIndex;
        private int leftPadWidth;

        private Builder(Class<T> clazz, Locale locale) {
            if (clazz == null) {
                throw new NullPointerException("Missing chronological type.");
            }
            if (locale == null) {
                throw new NullPointerException("Missing locale.");
            }
            this.chronology = Chronology.lookup(clazz);
            this.locale = locale;
            if (this.chronology == null) {
                throw new IllegalArgumentException("Not formattable: " + clazz);
            }
            this.steps = new ArrayList<FormatStep>();
            this.stack = new LinkedList();
            this.sectionID = 0;
            this.reservedIndex = -1;
            this.leftPadWidth = 0;
        }

        public Chronology<T> getChronology() {
            return this.chronology;
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addLongNumber(ChronoElement<Long> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addFixedInteger(ChronoElement<Integer> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addNumerical(ChronoElement<V> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addFixedNumerical(ChronoElement<V> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addFraction(ChronoElement<Integer> chronoElement, int n, int n2, boolean bl) {
            this.checkElement(chronoElement);
            boolean bl2 = !bl && n == n2;
            this.ensureOnlyOneFractional(bl2, bl);
            FractionProcessor fractionProcessor = new FractionProcessor(chronoElement, n, n2, bl);
            if (this.reservedIndex != -1 && bl2) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(fractionProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n));
                }
            } else {
                this.addProcessor(fractionProcessor);
            }
            return this;
        }

        public Builder<T> addFixedDecimal(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
            this.checkElement(chronoElement);
            this.ensureDecimalDigitsOnlyOnce();
            DecimalProcessor decimalProcessor = new DecimalProcessor(chronoElement, n, n2);
            if (this.reservedIndex != -1) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(decimalProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n - n2));
                }
            } else {
                this.addProcessor(decimalProcessor);
            }
            return this;
        }

        public Builder<T> addEnglishOrdinal(ChronoElement<Integer> chronoElement) {
            return this.addOrdinalProcessor(chronoElement, null);
        }

        public Builder<T> addOrdinal(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            if (map == null) {
                throw new NullPointerException("Missing ordinal indicators.");
            }
            return this.addOrdinalProcessor(chronoElement, map);
        }

        public Builder<T> addLiteral(char c) {
            return this.addLiteral(String.valueOf(c));
        }

        public Builder<T> addLiteral(String string) {
            this.addProcessor(new LiteralProcessor(string));
            return this;
        }

        public Builder<T> addLiteral(AttributeKey<Character> attributeKey) {
            this.addProcessor(new LiteralProcessor(attributeKey));
            return this;
        }

        public Builder<T> addIgnorableWhitespace() {
            this.addProcessor(IgnorableWhitespaceProcessor.SINGLETON);
            return this;
        }

        public Builder<T> addPattern(String string, ChronoPattern chronoPattern) {
            Object object;
            ChronoElement<?> chronoElement;
            int n;
            int n2;
            if (chronoPattern == null) {
                throw new NullPointerException("Missing pattern type.");
            }
            Object object2 = Collections.emptySet();
            int n3 = string.length();
            Locale locale = this.locale;
            if (!this.stack.isEmpty()) {
                locale = this.stack.getLast().get(Attributes.LOCALE, locale);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = string.charAt(n2);
                if (Builder.isSymbol((char)n)) {
                    n4 = n2++;
                    while (n2 < n3 && string.charAt(n2) == n) {
                        ++n2;
                    }
                    chronoElement = chronoPattern.registerSymbol(this, locale, (char)n, n2 - n4);
                    if (object2.isEmpty()) {
                        object2 = chronoElement;
                    } else {
                        object = new HashSet(object2);
                        object.addAll(chronoElement);
                        object2 = object;
                    }
                    --n2;
                    continue;
                }
                if (n == 39) {
                    n4 = n2++;
                    while (n2 < n3) {
                        if (string.charAt(n2) == '\'') {
                            if (n2 + 1 >= n3 || string.charAt(n2 + 1) != '\'') break;
                            ++n2;
                        }
                        ++n2;
                    }
                    if (n2 >= n3) {
                        throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                    }
                    if (n4 + 1 == n2) {
                        this.addLiteral('\'');
                        continue;
                    }
                    chronoElement = string.substring(n4 + 1, n2);
                    this.addLiteral(((String)((Object)chronoElement)).replace("''", "'"));
                    continue;
                }
                if (n == 91) {
                    this.startOptionalSection();
                    continue;
                }
                if (n == 93) {
                    this.endSection();
                    continue;
                }
                if (n == 35 || n == 123 || n == 125) {
                    throw new IllegalArgumentException("Pattern contains reserved character: '" + (char)n + "'");
                }
                this.addLiteral((char)n);
            }
            if (!object2.isEmpty()) {
                n2 = this.steps.size();
                block3: for (n = 0; n < n2; ++n) {
                    FormatStep formatStep = this.steps.get(n);
                    chronoElement = formatStep.getProcessor().getElement();
                    if (!this.chronology.isRegistered(chronoElement)) continue;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        ChronoElement chronoElement2 = (ChronoElement)object.next();
                        if (!chronoElement2.name().equals(chronoElement.name())) continue;
                        if (chronoElement2 == chronoElement) continue block3;
                        this.steps.set(n, formatStep.updateElement(chronoElement2));
                        continue block3;
                    }
                }
            }
            return this;
        }

        public Builder<T> addText(TextElement<?> textElement) {
            this.checkElement(textElement);
            this.addProcessor(TextProcessor.create(textElement));
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement) {
            this.checkElement(chronoElement);
            if (chronoElement instanceof TextElement) {
                TextElement textElement = (TextElement)TextElement.class.cast(chronoElement);
                this.addProcessor(TextProcessor.create(textElement));
            } else {
                Map map = Collections.emptyMap();
                this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            }
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement, Map<V, String> map) {
            this.checkElement(chronoElement);
            this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            return this;
        }

        public <V extends ChronoEntity<V>> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoFormatter<V> chronoFormatter) {
            return this.addCustomized(chronoElement, chronoFormatter, chronoFormatter);
        }

        public <V> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
            this.checkElement(chronoElement);
            this.addProcessor(new CustomizedProcessor<V>(chronoElement, chronoPrinter, chronoParser));
            return this;
        }

        public Builder<T> addTwoDigitYear(ChronoElement<Integer> chronoElement) {
            this.checkElement(chronoElement);
            this.checkAfterDecimalDigits(chronoElement);
            TwoDigitYearProcessor twoDigitYearProcessor = new TwoDigitYearProcessor(chronoElement);
            if (this.reservedIndex == -1) {
                this.addProcessor(twoDigitYearProcessor);
                this.reservedIndex = this.steps.size() - 1;
            } else {
                int n = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n);
                this.startSection(Attributes.LENIENCY, Leniency.STRICT);
                this.addProcessor(twoDigitYearProcessor);
                this.endSection();
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n;
                    this.steps.set(n, formatStep.reserve(2));
                }
            }
            return this;
        }

        public Builder<T> addTimezoneID() {
            Class<T> clazz = this.getChronology().getChronoType();
            if (UnixTime.class.isAssignableFrom(clazz)) {
                this.addProcessor(TimezoneIDProcessor.INSTANCE);
                return this;
            }
            throw new IllegalStateException("Only unix timestamps can have a timezone id.");
        }

        public Builder<T> addShortTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(true));
            return this;
        }

        public Builder<T> addLongTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(false));
            return this;
        }

        public Builder<T> addShortTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(true, set));
            return this;
        }

        public Builder<T> addLongTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(false, set));
            return this;
        }

        public Builder<T> addTimezoneOffset() {
            return this.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList("Z"));
        }

        public Builder<T> addTimezoneOffset(DisplayMode displayMode, boolean bl, List<String> list) {
            this.addProcessor(new TimezoneOffsetProcessor(displayMode, bl, list));
            return this;
        }

        public Builder<T> addShortLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(true));
            return this;
        }

        public Builder<T> addLongLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(false));
            return this;
        }

        public Builder<T> padNext(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (n > 0) {
                this.leftPadWidth = n;
            }
            return this;
        }

        public Builder<T> padPrevious(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (!this.steps.isEmpty() && n > 0) {
                int n2 = this.steps.size() - 1;
                FormatStep formatStep = this.steps.get(n2);
                int n3 = 0;
                if (!this.stack.isEmpty()) {
                    n3 = Builder.getSection(this.stack.getLast());
                }
                if (n3 == formatStep.getSection()) {
                    this.steps.set(n2, formatStep.pad(0, n));
                }
            }
            return this;
        }

        public Builder<T> startOptionalSection() {
            return this.startOptionalSection(null);
        }

        public Builder<T> startOptionalSection(final ChronoCondition<ChronoDisplay> chronoCondition) {
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            Attributes attributes = null;
            ChronoCondition<ChronoDisplay> chronoCondition2 = null;
            if (!this.stack.isEmpty()) {
                attributes = this.stack.getLast();
                builder.setAll(attributes);
                chronoCondition2 = attributes.getCondition();
            }
            builder.set(Attributes.LEVEL, Builder.getLevel(attributes) + 1);
            builder.set(Attributes.SECTION, ++this.sectionID);
            builder.set(Attributes.OPTIONAL, true);
            if (chronoCondition != null) {
                final ChronoCondition<ChronoDisplay> chronoCondition3 = chronoCondition2;
                chronoCondition2 = chronoCondition3 == null ? chronoCondition : new ChronoCondition<ChronoDisplay>(){

                    @Override
                    public boolean test(ChronoDisplay chronoDisplay) {
                        return chronoCondition3.test(chronoDisplay) && chronoCondition.test(chronoDisplay);
                    }
                };
                builder.setCondition(chronoCondition2);
            }
            this.stack.addLast(builder.build());
            return this;
        }

        public Builder<T> startSection(AttributeKey<Boolean> attributeKey, boolean bl) {
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            if (!this.stack.isEmpty()) {
                builder.setAll(this.stack.getLast());
            }
            this.stack.addLast(builder.set(attributeKey, bl).build());
            return this;
        }

        public Builder<T> startSection(AttributeKey<Integer> attributeKey, int n) {
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            if (!this.stack.isEmpty()) {
                builder.setAll(this.stack.getLast());
            }
            this.stack.addLast(builder.set(attributeKey, n).build());
            return this;
        }

        public Builder<T> startSection(AttributeKey<Character> attributeKey, char c) {
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            if (!this.stack.isEmpty()) {
                builder.setAll(this.stack.getLast());
            }
            this.stack.addLast(builder.set(attributeKey, c).build());
            return this;
        }

        public <A extends Enum<A>> Builder<T> startSection(AttributeKey<A> attributeKey, A a) {
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            if (!this.stack.isEmpty()) {
                builder.setAll(this.stack.getLast());
            }
            this.stack.addLast(builder.set(attributeKey, a).build());
            return this;
        }

        public Builder<T> endSection() {
            this.stack.removeLast();
            this.resetPadding();
            return this;
        }

        public ChronoFormatter<T> build() {
            return new ChronoFormatter(this.chronology, this.locale, this.steps);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            NumberProcessor<V> numberProcessor = new NumberProcessor<V>(chronoElement, bl, n, n2, signPolicy);
            if (bl) {
                if (this.reservedIndex == -1) {
                    this.addProcessor(numberProcessor);
                } else {
                    int n3 = this.reservedIndex;
                    FormatStep formatStep2 = this.steps.get(n3);
                    this.addProcessor(numberProcessor);
                    FormatStep formatStep3 = this.steps.get(this.steps.size() - 1);
                    if (formatStep2.getSection() == formatStep3.getSection()) {
                        this.reservedIndex = n3;
                        this.steps.set(n3, formatStep2.reserve(n));
                    }
                }
            } else {
                if (formatStep != null && formatStep.isNumerical()) {
                    throw new IllegalStateException("Numerical element with variable width can't be inserted after another numerical element. Consider \"addFixedXXX()\" instead.");
                }
                this.addProcessor(numberProcessor);
                this.reservedIndex = this.steps.size() - 1;
            }
            return this;
        }

        private Builder<T> addOrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            OrdinalProcessor ordinalProcessor = new OrdinalProcessor(chronoElement, map);
            if (formatStep != null && formatStep.isNumerical()) {
                throw new IllegalStateException("Ordinal element with variable width can't be inserted after another numerical element.");
            }
            this.addProcessor(ordinalProcessor);
            return this;
        }

        private void addProcessor(FormatProcessor<?> formatProcessor) {
            this.reservedIndex = -1;
            Attributes attributes = null;
            int n = 0;
            int n2 = 0;
            if (!this.stack.isEmpty()) {
                attributes = this.stack.getLast();
                n = Builder.getLevel(attributes);
                n2 = Builder.getSection(attributes);
            }
            FormatStep formatStep = new FormatStep(formatProcessor, n, n2, attributes);
            if (this.leftPadWidth > 0) {
                formatStep = formatStep.pad(this.leftPadWidth, 0);
                this.leftPadWidth = 0;
            }
            this.steps.add(formatStep);
        }

        private static int getLevel(Attributes attributes) {
            if (attributes == null) {
                return 0;
            }
            return attributes.get(Attributes.LEVEL, ZERO);
        }

        private static int getSection(Attributes attributes) {
            return attributes.get(Attributes.SECTION, ZERO);
        }

        private static void checkAttribute(AttributeKey<?> attributeKey) {
            if (attributeKey.name().charAt(0) == '_') {
                throw new IllegalArgumentException("Internal attribute not allowed: " + attributeKey.name());
            }
        }

        private void resetPadding() {
            this.leftPadWidth = 0;
        }

        private static boolean isSymbol(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private void checkElement(ChronoElement<?> chronoElement) {
            ChronoFormatter.checkElement(this.chronology, chronoElement);
        }

        private void ensureDecimalDigitsOnlyOnce() {
            for (FormatStep formatStep : this.steps) {
                if (!formatStep.isDecimal()) continue;
                throw new IllegalArgumentException("Cannot define more than one element with decimal digits.");
            }
        }

        private void ensureOnlyOneFractional(boolean bl, boolean bl2) {
            this.ensureDecimalDigitsOnlyOnce();
            if (!bl && !bl2 && this.reservedIndex != -1) {
                throw new IllegalArgumentException("Cannot add fractional element with variable width after another numerical element with variable width.");
            }
        }

        private FormatStep checkAfterDecimalDigits(ChronoElement<?> chronoElement) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null) {
                return null;
            }
            if (formatStep.isDecimal()) {
                throw new IllegalStateException(chronoElement.name() + " can't be inserted after an element" + " with decimal digits.");
            }
            return formatStep;
        }
    }
}

