/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.EpochDays;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.RuleComparator;
import net.time4j.tz.model.SPX;
import net.time4j.tz.model.TransitionModel;

final class RuleBasedTransitionModel
extends TransitionModel {
    private static final int LAST_CACHED_YEAR;
    private static final long serialVersionUID = 2456700806862862287L;
    private final transient ZonalTransition initial;
    private final transient List<DaylightSavingRule> rules;
    private final transient ConcurrentMap<Integer, List<ZonalTransition>> tCache = new ConcurrentHashMap<Integer, List<ZonalTransition>>();
    private final transient List<ZonalTransition> stdTransitions;
    private final transient boolean gregorian;

    RuleBasedTransitionModel(ZonalOffset zonalOffset, List<DaylightSavingRule> list) {
        this(zonalOffset, list, true);
    }

    RuleBasedTransitionModel(ZonalOffset zonalOffset, List<DaylightSavingRule> list, boolean bl) {
        this(new ZonalTransition(Long.MIN_VALUE, zonalOffset.getIntegralAmount(), zonalOffset.getIntegralAmount(), 0), list, bl);
    }

    RuleBasedTransitionModel(ZonalTransition zonalTransition, List<DaylightSavingRule> list, boolean bl) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing daylight saving rules.");
        }
        if (list.size() >= 128) {
            throw new IllegalArgumentException("Too many daylight saving rules: " + list);
        }
        if (bl) {
            list = new ArrayList<DaylightSavingRule>(list);
        }
        List<DaylightSavingRule> list2 = list;
        Collections.sort(list2, RuleComparator.INSTANCE);
        String string = null;
        if (list2.size() > 1) {
            for (DaylightSavingRule object2 : list2) {
                if (string == null) {
                    string = object2.getCalendarType();
                    continue;
                }
                if (string.equals(object2.getCalendarType())) continue;
                throw new IllegalArgumentException("Rules with different calendar systems not permitted.");
            }
        }
        this.gregorian = "iso8601".equals(string);
        Object object = zonalTransition;
        if (zonalTransition.getPosixTime() == Long.MIN_VALUE) {
            if (zonalTransition.getDaylightSavingOffset() != 0) {
                throw new IllegalArgumentException("Initial transition must not have any dst-offset: " + zonalTransition);
            }
            object = new ZonalTransition(Moment.axis().getMinimum().getPosixTime(), zonalTransition.getStandardOffset(), zonalTransition.getStandardOffset(), 0);
        } else {
            ZonalTransition l = RuleBasedTransitionModel.getNextTransition(zonalTransition.getPosixTime(), zonalTransition, list2);
            if (zonalTransition.getTotalOffset() != l.getPreviousOffset()) {
                throw new IllegalArgumentException("Inconsistent model: " + zonalTransition + " / " + list);
            }
        }
        this.initial = object;
        this.rules = Collections.unmodifiableList(list2);
        long l = TransitionModel.getFutureMoment(1);
        this.stdTransitions = RuleBasedTransitionModel.getTransitions(this.initial, this.rules, 0L, l);
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return ZonalOffset.ofTotalSeconds(this.initial.getTotalOffset());
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        long l = this.initial.getPosixTime();
        if (unixTime.getPosixTime() <= l) {
            return null;
        }
        ZonalTransition zonalTransition = null;
        int n = this.initial.getStandardOffset();
        int n2 = this.rules.size();
        DaylightSavingRule daylightSavingRule = this.rules.get(0);
        DaylightSavingRule daylightSavingRule2 = this.rules.get(n2 - 1);
        int n3 = RuleBasedTransitionModel.getShift(daylightSavingRule, n, daylightSavingRule2.getSavings());
        int n4 = RuleBasedTransitionModel.getYear(daylightSavingRule, unixTime.getPosixTime() + (long)n3);
        List<ZonalTransition> list = this.getTransitions(n4);
        for (int i = 0; i < n2; ++i) {
            ZonalTransition zonalTransition2 = list.get(i);
            long l2 = zonalTransition2.getPosixTime();
            if (unixTime.getPosixTime() < l2) {
                if (zonalTransition != null || (zonalTransition2 = i == 0 ? this.getTransitions(n4 - 1).get(n2 - 1) : list.get(i - 1)).getPosixTime() <= l) break;
                zonalTransition = zonalTransition2;
                break;
            }
            if (l2 <= l) continue;
            zonalTransition = zonalTransition2;
        }
        return zonalTransition;
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        long l = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        return this.getConflictTransition(gregorianDate, l);
    }

    @Override
    public ZonalTransition getNextTransition(UnixTime unixTime) {
        return RuleBasedTransitionModel.getNextTransition(unixTime.getPosixTime(), this.initial, this.rules);
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        long l = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        return this.getValidOffsets(gregorianDate, l);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return this.stdTransitions;
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return RuleBasedTransitionModel.getTransitions(this.initial, this.rules, unixTime.getPosixTime(), unixTime2.getPosixTime());
    }

    @Override
    public boolean hasNegativeDST() {
        for (DaylightSavingRule daylightSavingRule : this.rules) {
            if (daylightSavingRule.getSavings() >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RuleBasedTransitionModel) {
            RuleBasedTransitionModel ruleBasedTransitionModel = (RuleBasedTransitionModel)object;
            return this.initial.equals(ruleBasedTransitionModel.initial) && this.rules.equals(ruleBasedTransitionModel.rules);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.initial.hashCode() + 37 * this.rules.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[initial=");
        stringBuilder.append(this.initial);
        stringBuilder.append(",rules=");
        stringBuilder.append(this.rules);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        appendable.append("*** Last rules:").append(NEW_LINE);
        for (DaylightSavingRule daylightSavingRule : this.rules) {
            appendable.append(">>> ").append(daylightSavingRule.toString()).append(NEW_LINE);
        }
    }

    ZonalTransition getInitialTransition() {
        return this.initial;
    }

    List<DaylightSavingRule> getRules() {
        return this.rules;
    }

    ZonalTransition getConflictTransition(GregorianDate gregorianDate, long l) {
        int n;
        long l2 = this.initial.getPosixTime();
        if (l <= l2 + (long)(n = Math.max(this.initial.getPreviousOffset(), this.initial.getTotalOffset()))) {
            return null;
        }
        for (ZonalTransition zonalTransition : this.getTransitions(gregorianDate)) {
            long l3 = zonalTransition.getPosixTime();
            if (zonalTransition.isGap()) {
                if (l < l3 + (long)zonalTransition.getPreviousOffset()) {
                    return null;
                }
                if (l >= l3 + (long)zonalTransition.getTotalOffset()) continue;
                return zonalTransition;
            }
            if (!zonalTransition.isOverlap()) continue;
            if (l < l3 + (long)zonalTransition.getTotalOffset()) {
                return null;
            }
            if (l >= l3 + (long)zonalTransition.getPreviousOffset()) continue;
            return zonalTransition;
        }
        return null;
    }

    List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, long l) {
        long l2 = this.initial.getPosixTime();
        int n = this.initial.getTotalOffset();
        int n2 = Math.max(this.initial.getPreviousOffset(), n);
        if (l <= l2 + (long)n2) {
            return TransitionModel.toList(n);
        }
        for (ZonalTransition zonalTransition : this.getTransitions(gregorianDate)) {
            long l3 = zonalTransition.getPosixTime();
            n = zonalTransition.getTotalOffset();
            if (zonalTransition.isGap()) {
                if (l < l3 + (long)zonalTransition.getPreviousOffset()) {
                    return TransitionModel.toList(zonalTransition.getPreviousOffset());
                }
                if (l >= l3 + (long)n) continue;
                return Collections.emptyList();
            }
            if (!zonalTransition.isOverlap()) continue;
            if (l < l3 + (long)n) {
                return TransitionModel.toList(zonalTransition.getPreviousOffset());
            }
            if (l >= l3 + (long)zonalTransition.getPreviousOffset()) continue;
            return TransitionModel.toList(n, zonalTransition.getPreviousOffset());
        }
        return TransitionModel.toList(n);
    }

    static List<ZonalTransition> getTransitions(ZonalTransition zonalTransition, List<DaylightSavingRule> list, long l, long l2) {
        long l3 = zonalTransition.getPosixTime();
        if (l > l2) {
            throw new IllegalArgumentException("Start after end.");
        }
        if (l2 <= l3 || l == l2) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
        int n = Integer.MIN_VALUE;
        int n2 = list.size();
        int n3 = 0;
        int n4 = zonalTransition.getStandardOffset();
        while (true) {
            DaylightSavingRule daylightSavingRule = list.get(n3 % n2);
            DaylightSavingRule daylightSavingRule2 = list.get((n3 - 1 + n2) % n2);
            int n5 = RuleBasedTransitionModel.getShift(daylightSavingRule, n4, daylightSavingRule2.getSavings());
            if (n3 == 0) {
                n = RuleBasedTransitionModel.getYear(daylightSavingRule, Math.max(l, l3) + (long)n5);
            } else if (n3 % n2 == 0) {
                ++n;
            }
            long l4 = RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n, n5);
            ++n3;
            if (l4 >= l2) break;
            if (l4 < l || l4 <= l3) continue;
            arrayList.add(new ZonalTransition(l4, n4 + daylightSavingRule2.getSavings(), n4 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static ZonalTransition getNextTransition(long l, ZonalTransition zonalTransition, List<DaylightSavingRule> list) {
        long l2 = Math.max(l, zonalTransition.getPosixTime());
        int n = Integer.MIN_VALUE;
        int n2 = zonalTransition.getStandardOffset();
        ZonalTransition zonalTransition2 = null;
        int n3 = 0;
        int n4 = list.size();
        while (zonalTransition2 == null) {
            DaylightSavingRule daylightSavingRule = list.get(n3 % n4);
            DaylightSavingRule daylightSavingRule2 = list.get((n3 - 1 + n4) % n4);
            int n5 = RuleBasedTransitionModel.getShift(daylightSavingRule, n2, daylightSavingRule2.getSavings());
            if (n3 == 0) {
                n = RuleBasedTransitionModel.getYear(daylightSavingRule, l2 + (long)n5);
            } else if (n3 % n4 == 0) {
                ++n;
            }
            long l3 = RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n, n5);
            if (l3 > l2) {
                zonalTransition2 = new ZonalTransition(l3, n2 + daylightSavingRule2.getSavings(), n2 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings());
            }
            ++n3;
        }
        return zonalTransition2;
    }

    private static int getShift(DaylightSavingRule daylightSavingRule, int n, int n2) {
        OffsetIndicator offsetIndicator = daylightSavingRule.getIndicator();
        switch (offsetIndicator) {
            case UTC_TIME: {
                return 0;
            }
            case STANDARD_TIME: {
                return n;
            }
            case WALL_TIME: {
                return n + n2;
            }
        }
        throw new UnsupportedOperationException(offsetIndicator.name());
    }

    private static long getTransitionTime(DaylightSavingRule daylightSavingRule, int n, int n2) {
        PlainTimestamp plainTimestamp = daylightSavingRule.getDate(n).at(daylightSavingRule.getTimeOfDay());
        return plainTimestamp.at(ZonalOffset.ofTotalSeconds(n2)).getPosixTime();
    }

    private List<ZonalTransition> getTransitions(GregorianDate gregorianDate) {
        return this.getTransitions(this.rules.get(0).toCalendarYear(gregorianDate));
    }

    private List<ZonalTransition> getTransitions(int n) {
        Integer n2 = n;
        List list = (List)this.tCache.get(n2);
        if (list == null) {
            List list2;
            ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
            int n3 = this.initial.getStandardOffset();
            int n4 = this.rules.size();
            for (int i = 0; i < n4; ++i) {
                DaylightSavingRule daylightSavingRule = this.rules.get(i);
                DaylightSavingRule daylightSavingRule2 = this.rules.get((i - 1 + n4) % n4);
                int n5 = RuleBasedTransitionModel.getShift(daylightSavingRule, n3, daylightSavingRule2.getSavings());
                arrayList.add(new ZonalTransition(RuleBasedTransitionModel.getTransitionTime(daylightSavingRule, n, n5), n3 + daylightSavingRule2.getSavings(), n3 + daylightSavingRule.getSavings(), daylightSavingRule.getSavings()));
            }
            list = Collections.unmodifiableList(arrayList);
            if (n <= LAST_CACHED_YEAR && this.gregorian && (list2 = this.tCache.putIfAbsent(n2, list)) != null) {
                list = list2;
            }
        }
        return list;
    }

    private static int getYear(DaylightSavingRule daylightSavingRule, long l) {
        return daylightSavingRule.toCalendarYear(EpochDays.MODIFIED_JULIAN_DATE.transform(MathUtils.floorDivide(l, 86400), EpochDays.UNIX));
    }

    private Object writeReplace() {
        return new SPX(this, 125);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        long l = TransitionModel.getFutureMoment(100);
        long l2 = EpochDays.MODIFIED_JULIAN_DATE.transform(l, EpochDays.UNIX);
        LAST_CACHED_YEAR = GregorianMath.readYear(GregorianMath.toPackedDate(l2));
    }
}

