/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;

public enum TimeScale {
    POSIX,
    UTC,
    TAI,
    GPS,
    TT,
    UT;


    public static double deltaT(int n, int n2) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month out of range: " + n2);
        }
        double d = (double)n + ((double)n2 - 0.5) / 12.0;
        return TimeScale.deltaT(n, d);
    }

    public static double deltaT(GregorianDate gregorianDate) {
        int n = gregorianDate.getYear();
        int n2 = GregorianMath.isLeapYear(n) ? 366 : 365;
        int n3 = 0;
        int n4 = gregorianDate.getMonth();
        for (int i = 1; i < n4; ++i) {
            n3 += GregorianMath.getLengthOfMonth(n, i);
        }
        if ((n3 += gregorianDate.getDayOfMonth()) > n2) {
            throw new IllegalArgumentException(gregorianDate.toString());
        }
        if (n == -2001 && n3 == 365) {
            n = -2000;
            n3 = 1;
        }
        double d = (double)n + ((double)n3 - 1.0) / (double)n2;
        return TimeScale.deltaT(n, d);
    }

    private static double deltaT(int n, double d) {
        if (n < -2000 || n > 3000) {
            throw new IllegalArgumentException("Year out of range: " + n);
        }
        if (n > 2050) {
            double d2 = (d - 1820.0) / 100.0;
            return -20.0 + 32.0 * d2 * d2;
        }
        if (n >= 2018) {
            double d3 = d - 2000.0;
            return 64.16 + (0.0533 + 0.012125 * d3) * d3;
        }
        if (n >= 2005) {
            double d4 = d - 2000.0;
            return 63.5934 + (0.171417 + (0.014201 + (-0.00112745 + 4.2060317E-5 * d4) * d4) * d4) * d4;
        }
        if (n >= 1986) {
            double d5 = d - 2000.0;
            return 63.86 + (0.3345 + (-0.060374 + (0.0017275 + (6.51814E-4 + 2.373599E-5 * d5) * d5) * d5) * d5) * d5;
        }
        if (n >= 1961) {
            double d6 = d - 1975.0;
            return 45.45 + (1.067 + (0.0 - d6 / 718.0) * d6) * d6;
        }
        if (n >= 1941) {
            double d7 = d - 1950.0;
            return 29.07 + (0.407 + (0.0 + d7 / 2547.0) * d7) * d7;
        }
        if (n >= 1920) {
            double d8 = d - 1920.0;
            return 21.2 + (0.84493 + (-0.0761 + 0.0020936 * d8) * d8) * d8;
        }
        if (n >= 1900) {
            double d9 = d - 1900.0;
            return -2.79 + (1.494119 + (-0.0598939 + (0.0061966 - 1.97E-4 * d9) * d9) * d9) * d9;
        }
        if (n >= 1860) {
            double d10 = d - 1860.0;
            return 7.62 + (0.5737 + (-0.251754 + (0.01680668 + (-4.473624E-4 + d10 / 233174.0) * d10) * d10) * d10) * d10;
        }
        if (n >= 1800) {
            double d11 = d - 1800.0;
            return 13.72 + (-0.332447 + (0.0068612 + (0.0041116 + (-3.7436E-4 + (1.21272E-5 + (-1.699E-7 + 8.75E-10 * d11) * d11) * d11) * d11) * d11) * d11) * d11;
        }
        if (n >= 1700) {
            double d12 = d - 1700.0;
            return 8.83 + (0.1603 + (-0.0059285 + (1.3336E-4 + d12 / 1174000.0) * d12) * d12) * d12;
        }
        if (n >= 1600) {
            double d13 = d - 1600.0;
            return 120.0 + (-0.9808 + (-0.01532 + d13 / 7129.0) * d13) * d13;
        }
        if (n >= 500) {
            double d14 = (d - 1000.0) / 100.0;
            return 1574.2 + (-556.01 + (71.23472 + (0.319781 + (-0.8503463 + (-0.005050998 + 0.0083572073 * d14) * d14) * d14) * d14) * d14) * d14;
        }
        if (n >= -500) {
            double d15 = d / 100.0;
            return 10583.6 + (-1014.41 + (33.78311 + (-5.952053 + (-0.1798452 + (0.022174192 + 0.0090316521 * d15) * d15) * d15) * d15) * d15) * d15;
        }
        double d16 = (d - 1820.0) / 100.0;
        return -20.0 + 32.0 * d16 * d16;
    }
}

