/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.util.Locale;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoElement;
import net.time4j.format.CalendarText;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;

public enum HistoricEra implements CalendarEra
{
    BC,
    AD,
    HISPANIC,
    BYZANTINE,
    AB_URBE_CONDITA;


    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getIsoInstance(locale);
        return calendarText.getEras(textWidth).print(this);
    }

    public String getAlternativeName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getIsoInstance(locale);
        ChronoElement<HistoricEra> chronoElement = ChronoHistory.ofFirstGregorianReform().era();
        return calendarText.getTextForms(chronoElement, textWidth == TextWidth.WIDE ? "w" : "a", "alt").print(this);
    }

    public int annoDomini(int n) {
        try {
            switch (this) {
                case BC: {
                    return MathUtils.safeSubtract(1, n);
                }
                case AD: {
                    return n;
                }
                case HISPANIC: {
                    return MathUtils.safeSubtract(n, 38);
                }
                case BYZANTINE: {
                    return MathUtils.safeSubtract(n, 5508);
                }
                case AB_URBE_CONDITA: {
                    return MathUtils.safeSubtract(n, 753);
                }
            }
            throw new UnsupportedOperationException(this.name());
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
    }

    int yearOfEra(HistoricEra historicEra, int n) {
        int n2 = historicEra.annoDomini(n);
        try {
            switch (this) {
                case BC: {
                    return MathUtils.safeSubtract(1, n2);
                }
                case AD: {
                    return n2;
                }
                case HISPANIC: {
                    return MathUtils.safeAdd(n2, 38);
                }
                case BYZANTINE: {
                    return MathUtils.safeAdd(n2, 5508);
                }
                case AB_URBE_CONDITA: {
                    return MathUtils.safeAdd(n2, 753);
                }
            }
            throw new UnsupportedOperationException(this.name());
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
    }
}

