/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.time4j.ClockUnit;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;

class PrecisionElement<U extends Comparable<U>>
implements ChronoElement<U> {
    static final ChronoElement<ClockUnit> CLOCK_PRECISION = new PrecisionElement<ClockUnit>(ClockUnit.class, ClockUnit.HOURS, ClockUnit.NANOS);
    static final ChronoElement<TimeUnit> TIME_PRECISION = new PrecisionElement<TimeUnit>(TimeUnit.class, TimeUnit.DAYS, TimeUnit.NANOSECONDS);
    private final Class<U> type;
    private final transient U min;
    private final transient U max;

    private PrecisionElement(Class<U> clazz, U u, U u2) {
        this.type = clazz;
        this.min = u;
        this.max = u2;
    }

    @Override
    public String name() {
        return "PRECISION";
    }

    @Override
    public Class<U> getType() {
        return this.type;
    }

    @Override
    public U getDefaultMinimum() {
        return this.min;
    }

    @Override
    public U getDefaultMaximum() {
        return this.max;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        Comparable comparable = (Comparable)chronoDisplay.get(this);
        Comparable comparable2 = (Comparable)chronoDisplay2.get(this);
        if (this.type == ClockUnit.class) {
            return comparable.compareTo(comparable2);
        }
        return comparable2.compareTo(comparable);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.name();
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    private Object readResolve() {
        return this.type == ClockUnit.class ? CLOCK_PRECISION : TIME_PRECISION;
    }
}

