/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent.delays;

import java.time.Duration;
import net.tascalate.concurrent.DelayPolicy;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.delays.DelayPolicyWrapper;

public class BoundedMaxDelayPolicy
extends DelayPolicyWrapper {
    public static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    private final Duration maxDelay;

    public BoundedMaxDelayPolicy(DelayPolicy target) {
        this(target, 10000L);
    }

    public BoundedMaxDelayPolicy(DelayPolicy target, long maxDelayMillis) {
        this(target, Duration.ofMillis(maxDelayMillis));
    }

    public BoundedMaxDelayPolicy(DelayPolicy target, Duration maxDelay) {
        super(target);
        if (!DelayPolicy.isValid(maxDelay)) {
            throw new IllegalArgumentException("MaxDelay must be positive but was: " + maxDelay);
        }
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration delay(RetryContext context) {
        return BoundedMaxDelayPolicy.min(this.target.delay(context), this.maxDelay);
    }
}

