/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import net.tascalate.concurrent.LinkedCompletion;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.SharedFunctions;

class Timeouts {
    static final Duration NEGATIVE_DURATION = Duration.ofNanos(-1L);
    private static final Duration MAX_BY_NANOS = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration MAX_BY_MILLIS = Duration.ofMillis(Long.MAX_VALUE);
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread result = Executors.defaultThreadFactory().newThread(r);
            result.setDaemon(true);
            result.setName("net.tascalate.concurrent.Timeouts");
            return result;
        }
    });

    private Timeouts() {
    }

    static Promise<Duration> delay(Duration duration) {
        TimeUnit unit;
        long amount;
        if (duration.compareTo(MAX_BY_NANOS) < 0) {
            amount = duration.toNanos();
            unit = TimeUnit.NANOSECONDS;
        } else if (duration.compareTo(MAX_BY_MILLIS) < 0) {
            amount = duration.toMillis();
            unit = TimeUnit.MILLISECONDS;
        } else {
            amount = duration.getSeconds();
            unit = TimeUnit.SECONDS;
        }
        LinkedCompletion.FutureCompletion result = new LinkedCompletion.FutureCompletion();
        ScheduledFuture<Boolean> timeout = scheduler.schedule(() -> result.complete(duration), amount, unit);
        return result.dependsOn((Future<?>)timeout).toPromise();
    }

    static Promise<Duration> delay(long delay, TimeUnit timeUnit) {
        return Timeouts.delay(Timeouts.toDuration(delay, timeUnit));
    }

    static <T> Promise<T> failAfter(Duration duration) {
        TimeUnit unit;
        long amount;
        if (duration.compareTo(MAX_BY_NANOS) < 0) {
            amount = duration.toNanos();
            unit = TimeUnit.NANOSECONDS;
        } else if (duration.compareTo(MAX_BY_MILLIS) < 0) {
            amount = duration.toMillis();
            unit = TimeUnit.MILLISECONDS;
        } else {
            amount = duration.getSeconds();
            unit = TimeUnit.SECONDS;
        }
        LinkedCompletion.FutureCompletion result = new LinkedCompletion.FutureCompletion();
        ScheduledFuture<Boolean> timeout = scheduler.schedule(() -> result.completeExceptionally(new TimeoutException("Timeout after " + duration)), amount, unit);
        return result.dependsOn((Future<?>)timeout).toPromise();
    }

    static <T> Promise<T> failAfter(long delay, TimeUnit timeUnit) {
        return Timeouts.failAfter(Timeouts.toDuration(delay, timeUnit));
    }

    static Duration toDuration(long delay, TimeUnit timeUnit) {
        return Duration.of(delay, Timeouts.toChronoUnit(timeUnit));
    }

    static <T, U> BiConsumer<T, U> timeoutsCleanup(Promise<T> self, Promise<?> timeout, boolean cancelOnTimeout) {
        return (r, e) -> {
            if (cancelOnTimeout && timeout.isDone() && !timeout.isCancelled()) {
                self.cancel(true);
            }
            timeout.cancel(true);
        };
    }

    static <T, E extends Throwable> BiConsumer<T, E> configureDelay(Promise<? extends T> self, CompletableFuture<? super T> delayed, Duration duration, boolean delayOnError) {
        return (originalResult, originalError) -> {
            if (originalError == null || delayOnError && !self.isCancelled()) {
                Promise<Duration> timeout = Timeouts.delay(duration);
                delayed.whenComplete((r, e) -> timeout.cancel(true));
                timeout.whenComplete((r, timeoutError) -> {
                    if (null != timeoutError) {
                        delayed.completeExceptionally(SharedFunctions.wrapCompletionException(timeoutError));
                    } else if (null == originalError) {
                        delayed.complete(originalResult);
                    } else {
                        delayed.completeExceptionally(SharedFunctions.wrapCompletionException(originalError));
                    }
                });
            } else {
                delayed.completeExceptionally(SharedFunctions.wrapCompletionException(originalError));
            }
        };
    }

    private static ChronoUnit toChronoUnit(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit constant");
    }
}

