/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.tascalate.concurrent.CompletableTask;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.TaskExecutorService;
import net.tascalate.concurrent.ThreadPoolTaskExecutor;

public class TaskExecutors {
    public static TaskExecutorService newFixedThreadPool(int nThreads) {
        return new ThreadPoolTaskExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static TaskExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolTaskExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static TaskExecutorService newCachedThreadPool() {
        return new ThreadPoolTaskExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static TaskExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolTaskExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static TaskExecutorService newSingleThreadExecutor() {
        return TaskExecutors.adapt(Executors.newSingleThreadExecutor());
    }

    public static TaskExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return TaskExecutors.adapt(Executors.newSingleThreadExecutor(threadFactory));
    }

    public static TaskExecutorService adapt(ExecutorService executorService) {
        if (executorService instanceof TaskExecutorService) {
            return (TaskExecutorService)executorService;
        }
        return new TaskExecutorServiceAdapter(executorService);
    }

    static class TaskExecutorServiceAdapter
    implements TaskExecutorService {
        private final ExecutorService delegate;

        TaskExecutorServiceAdapter(ExecutorService executor) {
            this.delegate = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Promise<T> submit(Callable<T> callable) {
            CompletableTask<T> task = this.createTask(callable);
            this.delegate.execute(task);
            return task;
        }

        @Override
        public <T> Promise<T> submit(Runnable codeBlock, T result) {
            CompletableTask<T> task = this.createTask(Executors.callable(codeBlock, result));
            this.delegate.execute(task);
            return task;
        }

        @Override
        public Promise<?> submit(Runnable codeBlock) {
            CompletableTask<Object> task = this.createTask(Executors.callable(codeBlock, null));
            this.delegate.execute(task);
            return task;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        protected <T> CompletableTask<T> createTask(Callable<T> callable) {
            return new CompletableTask<T>(this, callable);
        }
    }
}

