/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import net.tascalate.concurrent.RetryException;
import net.tascalate.concurrent.RetryPolicy;

public class RetryContext {
    private final RetryPolicy policy;
    private final int retry;
    private final Duration lastCallDuration;
    private final Throwable lastThrowable;
    private static final ThreadLocal<RetryContext> CURRENT_CONTEXT = new ThreadLocal();

    public RetryContext(RetryPolicy policy, int retry, Duration lastCallDuration, Throwable lastThrowable) {
        this.policy = policy;
        this.retry = retry;
        this.lastCallDuration = lastCallDuration;
        this.lastThrowable = lastThrowable;
    }

    public static RetryContext initial(RetryPolicy policy) {
        return new RetryContext(policy, 0, Duration.ZERO, null);
    }

    public RetryPolicy.Outcome shouldContinue() {
        return this.policy.shouldContinue(this);
    }

    public int getRetryCount() {
        return this.retry;
    }

    public Duration getLastCallDuration() {
        return this.lastCallDuration;
    }

    public Throwable getLastThrowable() {
        return this.lastThrowable;
    }

    public RetryContext nextRetry(Duration callDuration) {
        return this.nextRetry(callDuration, null);
    }

    public RetryContext nextRetry(Duration callDuration, Throwable throwable) {
        return new RetryContext(this.policy, this.retry + 1, callDuration, throwable);
    }

    public RetryException asFailure() {
        RetryException result = new RetryException(this.retry, this.lastCallDuration, this.lastThrowable);
        result.fillInStackTrace();
        return result;
    }

    public RetryContext asPrevRetry() {
        if (this.retry == 0) {
            throw new IllegalStateException("Initial retry has no previous retry");
        }
        return new RetryContext(this.policy, this.retry - 1, this.lastCallDuration, this.lastThrowable);
    }

    public static RetryContext current() {
        return CURRENT_CONTEXT.get();
    }

    void enter() {
        CURRENT_CONTEXT.set(this);
    }

    void exit() {
        if (CURRENT_CONTEXT.get() == this) {
            CURRENT_CONTEXT.remove();
        }
    }
}

