/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class MultitargetException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final List<Throwable> exceptions;

    public MultitargetException(List<Throwable> exceptions) {
        this.exceptions = exceptions;
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    Optional<Throwable> getFirstException() {
        return this.exceptions.stream().filter(ex -> ex != null).findFirst();
    }

    public static MultitargetException of(Throwable exception) {
        return new MultitargetException(Collections.singletonList(exception));
    }
}

