/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.ConfigurableDependentPromise;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.decorators.ExecutorBoundDependentPromise;

public interface DependentPromise<T>
extends Promise<T> {
    public static <U> DependentPromise<U> from(Promise<U> source) {
        return ConfigurableDependentPromise.from(source);
    }

    public static <U> DependentPromise<U> from(Promise<U> source, Set<PromiseOrigin> defaultEnlistOptions) {
        return ConfigurableDependentPromise.from(source, defaultEnlistOptions);
    }

    @Override
    default public DependentPromise<T> defaultAsyncOn(Executor executor) {
        return new ExecutorBoundDependentPromise(this, executor);
    }

    @Override
    default public DependentPromise<T> delay(long timeout, TimeUnit unit) {
        return this.delay(timeout, unit, true);
    }

    @Override
    default public DependentPromise<T> delay(long timeout, TimeUnit unit, boolean delayOnError) {
        return this.delay(Timeouts.toDuration(timeout, unit), delayOnError);
    }

    @Override
    default public DependentPromise<T> delay(Duration duration) {
        return this.delay(duration, true);
    }

    @Override
    public DependentPromise<T> delay(Duration var1, boolean var2);

    default public DependentPromise<T> delay(long timeout, TimeUnit unit, boolean delayOnError, boolean enlistOrigin) {
        return this.delay(Timeouts.toDuration(timeout, unit), delayOnError, enlistOrigin);
    }

    public DependentPromise<T> delay(Duration var1, boolean var2, boolean var3);

    @Override
    default public DependentPromise<T> orTimeout(long timeout, TimeUnit unit) {
        return this.orTimeout(timeout, unit, true);
    }

    @Override
    default public DependentPromise<T> orTimeout(long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.orTimeout(Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    @Override
    default public DependentPromise<T> orTimeout(Duration duration) {
        return this.orTimeout(duration, true);
    }

    @Override
    public DependentPromise<T> orTimeout(Duration var1, boolean var2);

    default public DependentPromise<T> orTimeout(long timeout, TimeUnit unit, boolean cancelOnTimeout, boolean enlistOrigin) {
        return this.orTimeout(Timeouts.toDuration(timeout, unit), cancelOnTimeout, enlistOrigin);
    }

    public DependentPromise<T> orTimeout(Duration var1, boolean var2, boolean var3);

    @Override
    default public DependentPromise<T> onTimeout(T value, long timeout, TimeUnit unit) {
        return this.onTimeout((Object)value, timeout, unit, true);
    }

    @Override
    default public DependentPromise<T> onTimeout(T value, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout((Object)value, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    @Override
    default public DependentPromise<T> onTimeout(T value, Duration duration) {
        return this.onTimeout((Object)value, duration, true);
    }

    @Override
    default public DependentPromise<T> onTimeout(T value, Duration duration, boolean cancelOnTimeout) {
        return this.onTimeout(() -> value, duration, cancelOnTimeout);
    }

    @Override
    default public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit) {
        return this.onTimeout((Supplier)supplier, timeout, unit, true);
    }

    @Override
    default public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit, boolean cancelOnTimeout) {
        return this.onTimeout((Supplier)supplier, Timeouts.toDuration(timeout, unit), cancelOnTimeout);
    }

    @Override
    default public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, Duration duration) {
        return this.onTimeout((Supplier)supplier, duration, true);
    }

    @Override
    public DependentPromise<T> onTimeout(Supplier<? extends T> var1, Duration var2, boolean var3);

    default public DependentPromise<T> onTimeout(T value, long timeout, TimeUnit unit, boolean cancelOnTimeout, boolean enlistOrigin) {
        return this.onTimeout(value, Timeouts.toDuration(timeout, unit), cancelOnTimeout, enlistOrigin);
    }

    default public DependentPromise<T> onTimeout(T value, Duration duration, boolean cancelOnTimeout, boolean enlistOrigin) {
        return this.onTimeout(() -> value, duration, cancelOnTimeout, enlistOrigin);
    }

    default public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, long timeout, TimeUnit unit, boolean cancelOnTimeout, boolean enlistOrigin) {
        return this.onTimeout(supplier, Timeouts.toDuration(timeout, unit), cancelOnTimeout, enlistOrigin);
    }

    public DependentPromise<T> onTimeout(Supplier<? extends T> var1, Duration var2, boolean var3, boolean var4);

    public <U> DependentPromise<U> thenApply(Function<? super T, ? extends U> var1, boolean var2);

    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> var1, boolean var2);

    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> var1, Executor var2, boolean var3);

    public DependentPromise<Void> thenAccept(Consumer<? super T> var1, boolean var2);

    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> var1, boolean var2);

    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> var1, Executor var2, boolean var3);

    public DependentPromise<Void> thenRun(Runnable var1, boolean var2);

    public DependentPromise<Void> thenRunAsync(Runnable var1, boolean var2);

    public DependentPromise<Void> thenRunAsync(Runnable var1, Executor var2, boolean var3);

    public <U, V> DependentPromise<V> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Set<PromiseOrigin> var3);

    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Set<PromiseOrigin> var3);

    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Executor var3, Set<PromiseOrigin> var4);

    public <U> DependentPromise<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Set<PromiseOrigin> var3);

    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Set<PromiseOrigin> var3);

    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Executor var3, Set<PromiseOrigin> var4);

    public DependentPromise<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3, Set<PromiseOrigin> var4);

    public <U> DependentPromise<U> applyToEither(CompletionStage<? extends T> var1, Function<? super T, U> var2, Set<PromiseOrigin> var3);

    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Set<PromiseOrigin> var3);

    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Executor var3, Set<PromiseOrigin> var4);

    public DependentPromise<Void> acceptEither(CompletionStage<? extends T> var1, Consumer<? super T> var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Executor var3, Set<PromiseOrigin> var4);

    public DependentPromise<Void> runAfterEither(CompletionStage<?> var1, Runnable var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Set<PromiseOrigin> var3);

    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3, Set<PromiseOrigin> var4);

    public <U> DependentPromise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> var1, boolean var2);

    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, boolean var2);

    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, Executor var2, boolean var3);

    public DependentPromise<T> exceptionally(Function<Throwable, ? extends T> var1, boolean var2);

    public DependentPromise<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1, boolean var2);

    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, boolean var2);

    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, Executor var2, boolean var3);

    public <U> DependentPromise<U> handle(BiFunction<? super T, Throwable, ? extends U> var1, boolean var2);

    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, boolean var2);

    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, Executor var2, boolean var3);

    public CompletableFuture<T> toCompletableFuture(boolean var1);

    @Override
    public <U> DependentPromise<U> thenApply(Function<? super T, ? extends U> var1);

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> var1);

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> var1, Executor var2);

    public DependentPromise<Void> thenAccept(Consumer<? super T> var1);

    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> var1);

    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> var1, Executor var2);

    @Override
    public DependentPromise<Void> thenRun(Runnable var1);

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable var1);

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable var1, Executor var2);

    @Override
    public <U, V> DependentPromise<V> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Executor var3);

    public <U> DependentPromise<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Executor var3);

    public DependentPromise<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2);

    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2);

    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> DependentPromise<U> applyToEither(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Executor var3);

    public DependentPromise<Void> acceptEither(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Executor var3);

    public DependentPromise<Void> runAfterEither(CompletionStage<?> var1, Runnable var2);

    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2);

    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> DependentPromise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, Executor var2);

    @Override
    public DependentPromise<T> exceptionally(Function<Throwable, ? extends T> var1);

    @Override
    public DependentPromise<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, Executor var2);

    @Override
    public <U> DependentPromise<U> handle(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, Executor var2);
}

