/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.tascalate.concurrent.RetryContext;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.delays.BoundedMaxDelayPolicy;
import net.tascalate.concurrent.delays.BoundedMinDelayPolicy;
import net.tascalate.concurrent.delays.ExponentialDelayPolicy;
import net.tascalate.concurrent.delays.FirstRetryNoDelayPolicy;
import net.tascalate.concurrent.delays.FixedIntervalDelayPolicy;
import net.tascalate.concurrent.delays.ProportionalRandomDelayPolicy;
import net.tascalate.concurrent.delays.UniformRandomDelayPolicy;

public interface DelayPolicy {
    public static final DelayPolicy DEFAULT = new FirstRetryNoDelayPolicy(new FixedIntervalDelayPolicy());
    public static final DelayPolicy INVALID = ctx -> Timeouts.NEGATIVE_DURATION;

    public Duration delay(RetryContext var1);

    public static DelayPolicy fixedInterval() {
        return new FixedIntervalDelayPolicy();
    }

    public static DelayPolicy fixedInterval(Duration interval) {
        return new FixedIntervalDelayPolicy(interval);
    }

    public static DelayPolicy fixedInterval(long interval, TimeUnit timeUnit) {
        return DelayPolicy.fixedInterval(Timeouts.toDuration(interval, timeUnit));
    }

    public static DelayPolicy fixedInterval(long intervalMillis) {
        return DelayPolicy.fixedInterval(Duration.ofMillis(intervalMillis));
    }

    public static DelayPolicy exponential(double multiplier) {
        return new ExponentialDelayPolicy(multiplier);
    }

    public static DelayPolicy exponential(Duration initialDelay, double multiplier) {
        return new ExponentialDelayPolicy(initialDelay, multiplier);
    }

    public static DelayPolicy exponential(long initialDelay, TimeUnit timeUnit, double multiplier) {
        return DelayPolicy.exponential(Timeouts.toDuration(initialDelay, timeUnit), multiplier);
    }

    public static DelayPolicy exponential(long initialDelayMillis, double multiplier) {
        return DelayPolicy.exponential(Duration.ofMillis(initialDelayMillis), multiplier);
    }

    default public DelayPolicy withUniformJitter() {
        return new UniformRandomDelayPolicy(this);
    }

    default public DelayPolicy withUniformJitter(long range) {
        return this.withUniformJitter(range, TimeUnit.MILLISECONDS);
    }

    default public DelayPolicy withUniformJitter(long range, TimeUnit timeUnit) {
        return this.withUniformJitter(Timeouts.toDuration(range, timeUnit));
    }

    default public DelayPolicy withUniformJitter(Duration range) {
        return new UniformRandomDelayPolicy(this, range);
    }

    default public DelayPolicy withProportionalJitter() {
        return new ProportionalRandomDelayPolicy(this);
    }

    default public DelayPolicy withProportionalJitter(double multiplier) {
        return new ProportionalRandomDelayPolicy(this, multiplier);
    }

    default public DelayPolicy withMinDelay() {
        return new BoundedMinDelayPolicy(this);
    }

    default public DelayPolicy withMinDelay(Duration minDelay) {
        return new BoundedMinDelayPolicy(this, minDelay);
    }

    default public DelayPolicy withMinDelay(long minDelay, TimeUnit timeUnit) {
        return this.withMaxDelay(Timeouts.toDuration(minDelay, timeUnit));
    }

    default public DelayPolicy withMinDelay(long minDelayMillis) {
        return this.withMinDelay(Duration.ofMillis(minDelayMillis));
    }

    default public DelayPolicy withMaxDelay() {
        return new BoundedMaxDelayPolicy(this);
    }

    default public DelayPolicy withMaxDelay(Duration maxDelay) {
        return new BoundedMaxDelayPolicy(this, maxDelay);
    }

    default public DelayPolicy withMaxDelay(long maxDelay, TimeUnit timeUnit) {
        return this.withMaxDelay(Timeouts.toDuration(maxDelay, timeUnit));
    }

    default public DelayPolicy withMaxDelay(long maxDelayMillis) {
        return this.withMaxDelay(Duration.ofMillis(maxDelayMillis));
    }

    default public DelayPolicy withFirstRetryNoDelay() {
        return new FirstRetryNoDelayPolicy(this);
    }

    public static boolean isValid(Duration d) {
        return !d.isNegative() && !d.isZero();
    }
}

