/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.tascalate.concurrent.DependentPromise;
import net.tascalate.concurrent.LinkedCompletion;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.SharedFunctions;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.decorators.AbstractPromiseDecorator;

public class ConfigurableDependentPromise<T>
implements DependentPromise<T> {
    protected final Promise<T> delegate;
    protected final CompletionStage<?>[] cancellableOrigins;
    private final Set<PromiseOrigin> defaultEnlistOptions;

    protected ConfigurableDependentPromise(Promise<T> delegate, Set<PromiseOrigin> defaultEnlistOptions, CompletionStage<?>[] cancellableOrigins) {
        this.delegate = delegate;
        this.defaultEnlistOptions = defaultEnlistOptions == null || defaultEnlistOptions.isEmpty() ? PromiseOrigin.NONE : defaultEnlistOptions;
        this.cancellableOrigins = cancellableOrigins;
    }

    public static <U> DependentPromise<U> from(Promise<U> source) {
        return ConfigurableDependentPromise.from(source, PromiseOrigin.NONE);
    }

    public static <U> DependentPromise<U> from(Promise<U> source, Set<PromiseOrigin> defaultEnlistOptions) {
        return ConfigurableDependentPromise.doWrap(source, defaultEnlistOptions, null);
    }

    protected <U> DependentPromise<U> wrap(Promise<U> original, CompletionStage<?>[] cancellableOrigins) {
        return ConfigurableDependentPromise.doWrap(original, this.defaultEnlistOptions, cancellableOrigins);
    }

    private static <U> DependentPromise<U> doWrap(Promise<U> original, Set<PromiseOrigin> defaultEnlistOptions, CompletionStage<?>[] cancellableOrigins) {
        ConfigurableDependentPromise<U> result;
        if ((null == cancellableOrigins || cancellableOrigins.length == 0) && original instanceof ConfigurableDependentPromise) {
            ConfigurableDependentPromise ioriginal = (ConfigurableDependentPromise)original;
            if (ConfigurableDependentPromise.identicalSets(ioriginal.defaultEnlistOptions, defaultEnlistOptions)) {
                return ioriginal;
            }
        }
        if ((result = new ConfigurableDependentPromise<U>(original, defaultEnlistOptions, cancellableOrigins)).isCancelled()) {
            ConfigurableDependentPromise.cancelPromises(result.cancellableOrigins, true);
        }
        return result;
    }

    @Override
    public DependentPromise<T> delay(Duration duration, boolean delayOnError) {
        return this.delay(duration, delayOnError, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> delay(Duration duration, boolean delayOnError, boolean enlistOrigin) {
        CompletableFuture delayed = new CompletableFuture();
        this.whenComplete(Timeouts.configureDelay(this, delayed, duration, delayOnError));
        return this.thenCombineAsync(delayed, (? super T r, ? super U d) -> r, enlistOrigin ? PromiseOrigin.ALL : PromiseOrigin.PARAM_ONLY);
    }

    @Override
    public DependentPromise<T> orTimeout(Duration duration, boolean cancelOnTimeout) {
        return this.orTimeout(duration, cancelOnTimeout, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> orTimeout(Duration duration, boolean cancelOnTimeout, boolean enlistOrigin) {
        Promise onTimeout = Timeouts.failAfter(duration);
        DependentPromise result = this.applyToEitherAsync(onTimeout, Function.identity(), enlistOrigin ? PromiseOrigin.ALL : PromiseOrigin.PARAM_ONLY);
        result.whenComplete(Timeouts.timeoutsCleanup(this, onTimeout, cancelOnTimeout));
        return result;
    }

    @Override
    public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, Duration duration, boolean cancelOnTimeout) {
        return this.onTimeout(supplier, duration, cancelOnTimeout, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> onTimeout(Supplier<? extends T> supplier, Duration duration, boolean cancelOnTimeout, boolean enlistOrigin) {
        Function<Object, Supplier> valueToSupplier = v -> () -> v;
        DependentPromise<Supplier> onTimeout = Timeouts.delay(duration).dependent().thenApply(d -> supplier, true);
        DependentPromise<Object> result = this.thenApply(valueToSupplier, enlistOrigin).applyToEitherAsync(onTimeout, Supplier::get, PromiseOrigin.ALL);
        result.whenComplete(Timeouts.timeoutsCleanup(this, onTimeout, cancelOnTimeout));
        return result;
    }

    @Override
    public <U> DependentPromise<U> thenApply(Function<? super T, ? extends U> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenApply(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenApplyAsync(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenApplyAsync(fn, executor), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenAccept(Consumer<? super T> action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenAccept((Consumer)action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenAcceptAsync((Consumer)action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenAcceptAsync((Consumer)action, executor), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenRun(Runnable action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenRun(action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenRunAsync(action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable action, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.thenRunAsync(action, executor), this.origin(enlistOrigin));
    }

    @Override
    public <U, V> DependentPromise<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenCombine(other, fn), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenCombineAsync(other, fn), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenCombineAsync(other, fn, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenAcceptBoth(other, (BiConsumer)action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenAcceptBothAsync(other, (BiConsumer)action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.thenAcceptBothAsync(other, (BiConsumer)action, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterBoth(CompletionStage<?> other, Runnable action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterBoth((CompletionStage)other, action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterBothAsync((CompletionStage)other, action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterBothAsync((CompletionStage)other, action, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.applyToEither((CompletionStage)other, fn), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.applyToEitherAsync((CompletionStage)other, fn), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise<U>)this.delegate.applyToEitherAsync((CompletionStage)other, fn, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.acceptEither((CompletionStage)other, (Consumer)action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterEither(CompletionStage<?> other, Runnable action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterEither((CompletionStage)other, action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterEitherAsync((CompletionStage)other, action), this.originAndParam(other, enlistOptions));
    }

    @Override
    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor, Set<PromiseOrigin> enlistOptions) {
        return this.wrap((Promise)this.delegate.runAfterEitherAsync((CompletionStage)other, action, executor), this.originAndParam(other, enlistOptions));
    }

    @Override
    public <U> DependentPromise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenCompose(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenComposeAsync(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.thenComposeAsync(fn, executor), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<T> exceptionally(Function<Throwable, ? extends T> fn, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.exceptionally(fn), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<T> whenComplete(BiConsumer<? super T, ? super Throwable> action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.whenComplete(action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.whenCompleteAsync(action), this.origin(enlistOrigin));
    }

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise)this.delegate.whenCompleteAsync(action, executor), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> handle(BiFunction<? super T, Throwable, ? extends U> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.handle(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.handleAsync(fn), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor, boolean enlistOrigin) {
        return this.wrap((Promise<U>)this.delegate.handleAsync(fn, executor), this.origin(enlistOrigin));
    }

    @Override
    public <U> DependentPromise<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.thenApply(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.thenApplyAsync(fn, executor, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenAccept(Consumer<? super T> action) {
        return this.thenAccept(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.thenAcceptAsync(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.thenAcceptAsync(action, executor, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenRun(Runnable action) {
        return this.thenRun(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenRunAsync(action, executor, this.defaultEnlistOrigin());
    }

    @Override
    public <U, V> DependentPromise<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombine(other, fn, this.defaultEnlistOptions);
    }

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineAsync(other, fn, this.defaultEnlistOptions);
    }

    @Override
    public <U, V> DependentPromise<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.thenCombineAsync(other, fn, executor, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBoth(other, action, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBothAsync(other, action, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.thenAcceptBothAsync(other, action, executor, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.runAfterBoth(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.runAfterBothAsync(other, action, executor, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEither(other, fn, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEitherAsync(other, fn, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.applyToEitherAsync(other, fn, executor, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEither(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEitherAsync(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.acceptEitherAsync(other, action, executor, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.runAfterEither(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync(other, action, this.defaultEnlistOptions);
    }

    @Override
    public DependentPromise<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.runAfterEitherAsync(other, action, executor, this.defaultEnlistOptions);
    }

    @Override
    public <U> DependentPromise<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenCompose(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.thenComposeAsync(fn, executor, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.exceptionally(fn, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenComplete(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsync(action, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.whenCompleteAsync(action, executor, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.handle(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.handleAsync(fn, this.defaultEnlistOrigin());
    }

    @Override
    public <U> DependentPromise<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.handleAsync(fn, executor, this.defaultEnlistOrigin());
    }

    @Override
    public DependentPromise<T> dependent() {
        return this.dependent(PromiseOrigin.NONE);
    }

    @Override
    public DependentPromise<T> dependent(Set<PromiseOrigin> defaultEnlistOptions) {
        if (null == defaultEnlistOptions) {
            defaultEnlistOptions = PromiseOrigin.NONE;
        }
        if (ConfigurableDependentPromise.identicalSets(defaultEnlistOptions, this.defaultEnlistOptions)) {
            return this;
        }
        return ConfigurableDependentPromise.from(null == this.cancellableOrigins || this.cancellableOrigins.length == 0 ? this.delegate : this.cancellablePromiseOf(this.delegate), defaultEnlistOptions);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.delegate.cancel(mayInterruptIfRunning)) {
            ConfigurableDependentPromise.cancelPromises(this.cancellableOrigins, mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }

    @Override
    public T getNow(T valueIfAbsent) throws CancellationException, CompletionException {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public T getNow(Supplier<? extends T> valueIfAbsent) throws CancellationException, CompletionException {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public T join() throws CancellationException, CompletionException {
        return this.delegate.join();
    }

    @Override
    public Promise<T> raw() {
        if (null == this.cancellableOrigins || this.cancellableOrigins.length == 0) {
            return this.delegate.raw();
        }
        return this.cancellablePromiseOf(this.delegate.raw());
    }

    protected Promise<T> cancellablePromiseOf(Promise<T> original) {
        return new UndecoratedCancellationPromise<T>(original, this.cancellableOrigins);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.toCompletableFuture(this.defaultEnlistOrigin());
    }

    @Override
    public CompletableFuture<T> toCompletableFuture(boolean enlistOrigin) {
        if (!enlistOrigin) {
            return this.delegate.toCompletableFuture();
        }
        LinkedCompletion.FutureCompletion result = new LinkedCompletion.FutureCompletion().dependsOn(this);
        this.whenComplete((T r, U e) -> {
            if (null != e) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(r);
            }
        });
        return result;
    }

    private CompletionStage<?>[] origin(boolean enlist) {
        if (enlist) {
            CompletionStage[] result = new CompletionStage[]{this};
            return result;
        }
        return null;
    }

    private CompletionStage<?>[] originAndParam(CompletionStage<?> param, Set<PromiseOrigin> enlistOptions) {
        CompletionStage[] result = new CompletionStage[enlistOptions.size()];
        int idx = 0;
        if (enlistOptions.contains((Object)PromiseOrigin.THIS)) {
            result[idx++] = this;
        }
        if (enlistOptions.contains((Object)PromiseOrigin.PARAM) && param != null) {
            result[idx++] = param;
        }
        return result;
    }

    private boolean defaultEnlistOrigin() {
        return this.defaultEnlistOptions.contains((Object)PromiseOrigin.THIS);
    }

    static void cancelPromises(CompletionStage<?>[] promises, boolean mayInterruptIfRunning) {
        if (null != promises) {
            Arrays.stream(promises).filter(p -> p != null).forEach(p -> SharedFunctions.cancelPromise(p, mayInterruptIfRunning));
        }
    }

    private static boolean identicalSets(Set<?> a, Set<?> b) {
        return a.containsAll(b) && b.containsAll(a);
    }

    static class UndecoratedCancellationPromise<T>
    extends AbstractPromiseDecorator<T, Promise<T>> {
        private final CompletionStage<?>[] dependent;

        UndecoratedCancellationPromise(Promise<T> original, CompletionStage<?>[] dependent) {
            super(original);
            this.dependent = dependent;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                ConfigurableDependentPromise.cancelPromises(this.dependent, mayInterruptIfRunning);
                return true;
            }
            return false;
        }

        @Override
        public Promise<T> raw() {
            return this;
        }

        @Override
        protected <U> Promise<U> wrap(CompletionStage<U> original) {
            return (Promise)original;
        }
    }
}

