/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.tascalate.concurrent.AbstractCompletableTask;
import net.tascalate.concurrent.CompletableSubTask;
import net.tascalate.concurrent.Promise;
import net.tascalate.concurrent.PromiseOrigin;
import net.tascalate.concurrent.Timeouts;
import net.tascalate.concurrent.decorators.ExecutorBoundPromise;

public class CompletableTask<T>
extends AbstractCompletableTask<T>
implements RunnableFuture<T> {
    protected CompletableTask(Executor executor, Callable<T> callable) {
        super(executor, callable);
    }

    @Override
    public void run() {
        this.task.run();
    }

    public static <T> Promise<T> complete(T value, Executor defaultExecutor) {
        CompletableTask<Object> result = new CompletableTask<Object>(defaultExecutor, () -> value);
        SAME_THREAD_EXECUTOR.execute(result);
        return result;
    }

    public static Promise<Void> asyncOn(Executor executor) {
        return CompletableTask.complete(null, executor);
    }

    public static Promise<Void> asyncOn(Executor executor, boolean enforceDefaultAsync) {
        Promise<Object> result = CompletableTask.complete(null, executor);
        if (enforceDefaultAsync) {
            class DefaultAsyncDecorator<T>
            extends ExecutorBoundPromise<T> {
                final /* synthetic */ Executor val$executor;

                public DefaultAsyncDecorator(Promise<T> promise) {
                    this.val$executor = promise;
                    super(delegate, (Executor)((Object)promise));
                }

                @Override
                protected <U> Promise<U> wrap(CompletionStage<U> original) {
                    return new DefaultAsyncDecorator((Promise)original, this.val$executor);
                }

                @Override
                public Promise<T> raw() {
                    return this;
                }
            }
            return new DefaultAsyncDecorator(result, executor);
        }
        return result;
    }

    public static Promise<Void> runAsync(Runnable runnable, Executor executor) {
        CompletableTask<Void> result = new CompletableTask<Void>(executor, () -> {
            runnable.run();
            return null;
        });
        executor.execute(result);
        return result;
    }

    public static <U> Promise<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        CompletableTask<Object> result = new CompletableTask<Object>(executor, () -> supplier.get());
        executor.execute(result);
        return result;
    }

    public static <T> Promise<T> waitFor(CompletionStage<T> stage, Executor executor) {
        return CompletableTask.waitFor(stage, executor, false);
    }

    public static <T> Promise<T> waitFor(CompletionStage<T> stage, Executor executor, boolean enlistOrigin) {
        return CompletableTask.asyncOn(executor).dependent().thenCombineAsync(stage, (? super T u, ? super U v) -> v, enlistOrigin ? PromiseOrigin.PARAM_ONLY : PromiseOrigin.NONE).raw();
    }

    public static Promise<Duration> delay(long timeout, TimeUnit unit, Executor executor) {
        return CompletableTask.delay(Timeouts.toDuration(timeout, unit), executor);
    }

    public static Promise<Duration> delay(Duration duration, Executor executor) {
        return CompletableTask.waitFor(Timeouts.delay(duration), executor, true);
    }

    @Override
    void fireTransition(Callable<T> code) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected <U> AbstractCompletableTask<U> createCompletionStage(Executor executor) {
        return new CompletableSubTask(executor);
    }
}

