/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import net.tascalate.concurrent.AbstractCompletableTask;

class CompletableSubTask<T>
extends AbstractCompletableTask<T> {
    CompletableSubTask(Executor executor) {
        super(executor, new DelegatingCallable());
    }

    @Override
    void fireTransition(Callable<T> code) {
        DelegatingCallable transitionCall = (DelegatingCallable)this.action;
        transitionCall.setup(code);
        this.task.run();
    }

    @Override
    protected <U> AbstractCompletableTask<U> createCompletionStage(Executor executor) {
        return new CompletableSubTask<T>(executor);
    }

    static class DelegatingCallable<T>
    implements Callable<T> {
        private final AtomicReference<Callable<T>> delegateRef = new AtomicReference<Object>(null);

        DelegatingCallable() {
        }

        void setup(Callable<T> delegate) {
            boolean updated = this.delegateRef.compareAndSet(null, delegate);
            if (!updated) {
                throw new IllegalStateException("Delegate may be set only once");
            }
        }

        @Override
        public T call() throws Exception {
            Callable<T> delegate = this.delegateRef.get();
            if (null == delegate) {
                throw new IllegalStateException("Call is not configured");
            }
            return delegate.call();
        }
    }
}

