/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import net.tascalate.concurrent.CompletableFutureWrapper;
import net.tascalate.concurrent.CompletableTask;
import net.tascalate.concurrent.Promise;

public class CompletablePromise<T>
extends CompletableFutureWrapper<T> {
    public CompletablePromise() {
        this(new CompletableFuture());
    }

    public CompletablePromise(CompletableFuture<T> delegate) {
        super(delegate);
    }

    protected boolean onSuccess(T value) {
        return ((CompletableFuture)this.delegate).complete(value);
    }

    protected boolean onFailure(Throwable ex) {
        return ((CompletableFuture)this.delegate).completeExceptionally(ex);
    }

    public Promise<T> completeAsync(Supplier<? extends T> supplier) {
        return this.completeAsync(supplier, ForkJoinPool.commonPool());
    }

    public Promise<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        CompletableTask.supplyAsync(supplier, executor).thenAccept(this::onSuccess);
        return this;
    }

    @Override
    protected <U> Promise<U> wrap(CompletionStage<U> original) {
        return new CompletablePromise<T>((CompletableFuture)original);
    }
}

