/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.concurrent;

import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

class CallbackRegistry<T> {
    private State<T> state = InitialState.access$000();
    private final Object mutex = new Object();

    CallbackRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <U> void addCallbacks(Consumer<? super Callable<U>> stageTransition, Function<? super T, ? extends U> successCallback, Function<Throwable, ? extends U> failureCallback, Executor executor) {
        Objects.requireNonNull(successCallback, "'successCallback' must not be null");
        Objects.requireNonNull(failureCallback, "'failureCallback' must not be null");
        Objects.requireNonNull(executor, "'executor' must not be null");
        Consumer<? super Callable<U>> typedTransition = stageTransition;
        Object object = this.mutex;
        synchronized (object) {
            this.state = this.state.addCallbacks(typedTransition, successCallback, failureCallback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean success(T result) {
        State<T> oldState;
        Object object = this.mutex;
        synchronized (object) {
            if (this.state.isCompleted()) {
                return false;
            }
            oldState = this.state;
            this.state = this.state.getSuccessState(result);
        }
        oldState.callSuccessCallbacks(result);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean failure(Throwable failure) {
        State<T> oldState;
        Object object = this.mutex;
        synchronized (object) {
            if (this.state.isCompleted()) {
                return false;
            }
            oldState = this.state;
            this.state = this.state.getFailureState(failure);
        }
        oldState.callFailureCallbacks(failure);
        return true;
    }

    private static <S, U> void callCallback(Consumer<? super Callable<?>> stageTransition, Function<? super S, ? extends U> callback, S value, Executor executor) {
        Callable<Object> callable = () -> callback.apply((Object)value);
        try {
            executor.execute(() -> stageTransition.accept(callable));
        }
        catch (RejectedExecutionException ex) {
            Callable<Object> propagateError = () -> {
                throw ex;
            };
            stageTransition.accept(propagateError);
        }
    }

    private static final class CallbackHolder<S> {
        private final Consumer<? super Callable<?>> stageTransition;
        private final Function<? super S, ?> successCallback;
        private final Function<Throwable, ?> failureCallback;
        private final Executor executor;

        private CallbackHolder(Consumer<? super Callable<?>> stageTransition, Function<? super S, ?> successCallback, Function<Throwable, ?> failureCallback, Executor executor) {
            this.stageTransition = stageTransition;
            this.successCallback = successCallback;
            this.failureCallback = failureCallback;
            this.executor = executor;
        }

        void callSuccessCallback(S result) {
            CallbackRegistry.callCallback(this.stageTransition, this.successCallback, result, this.executor);
        }

        void callFailureCallback(Throwable failure) {
            CallbackRegistry.callCallback(this.stageTransition, this.failureCallback, failure, this.executor);
        }
    }

    private static final class FailureState<S>
    extends State<S> {
        private final Throwable failure;

        private FailureState(Throwable failure) {
            this.failure = failure;
        }

        @Override
        protected State<S> addCallbacks(Consumer<? super Callable<?>> stageTransition, Function<? super S, ?> successCallback, Function<Throwable, ?> failureCallback, Executor executor) {
            CallbackRegistry.callCallback(stageTransition, failureCallback, this.failure, executor);
            return this;
        }
    }

    private static final class SuccessState<S>
    extends State<S> {
        private final S result;

        private SuccessState(S result) {
            this.result = result;
        }

        @Override
        protected State<S> addCallbacks(Consumer<? super Callable<?>> stageTransition, Function<? super S, ?> successCallback, Function<Throwable, ?> failureCallback, Executor executor) {
            CallbackRegistry.callCallback(stageTransition, successCallback, this.result, executor);
            return this;
        }
    }

    private static class IntermediateState<S>
    extends State<S> {
        private final Queue<CallbackHolder<? super S>> callbacks = new LinkedList<CallbackHolder<? super S>>();

        private IntermediateState() {
        }

        @Override
        protected State<S> addCallbacks(Consumer<? super Callable<?>> stageTransition, Function<? super S, ?> successCallback, Function<Throwable, ?> failureCallback, Executor executor) {
            this.callbacks.add(new CallbackHolder(stageTransition, successCallback, failureCallback, executor));
            return this;
        }

        @Override
        protected State<S> getSuccessState(S result) {
            return new SuccessState(result);
        }

        @Override
        protected void callSuccessCallbacks(S result) {
            for (CallbackHolder callbackHolder : this.callbacks) {
                callbackHolder.callSuccessCallback(result);
            }
        }

        @Override
        protected State<S> getFailureState(Throwable failure) {
            return new FailureState(failure);
        }

        @Override
        protected void callFailureCallbacks(Throwable failure) {
            for (CallbackHolder callbackHolder : this.callbacks) {
                callbackHolder.callFailureCallback(failure);
            }
        }

        @Override
        protected boolean isCompleted() {
            return false;
        }
    }

    private static class InitialState<S>
    extends State<S> {
        private static final InitialState<Object> instance = new InitialState();

        private InitialState() {
        }

        @Override
        protected State<S> addCallbacks(Consumer<? super Callable<?>> stageTransition, Function<? super S, ?> successCallback, Function<Throwable, ?> failureCallback, Executor executor) {
            IntermediateState<? super S> intermediateState = new IntermediateState<S>();
            intermediateState.addCallbacks(stageTransition, successCallback, failureCallback, executor);
            return intermediateState;
        }

        @Override
        protected State<S> getSuccessState(S result) {
            return new SuccessState(result);
        }

        @Override
        protected State<S> getFailureState(Throwable failure) {
            return new FailureState(failure);
        }

        @Override
        protected boolean isCompleted() {
            return false;
        }

        private static <T> State<T> instance() {
            return instance;
        }

        static /* synthetic */ State access$000() {
            return InitialState.instance();
        }
    }

    private static abstract class State<S> {
        private State() {
        }

        protected abstract State<S> addCallbacks(Consumer<? super Callable<?>> var1, Function<? super S, ?> var2, Function<Throwable, ?> var3, Executor var4);

        protected State<S> getSuccessState(S result) {
            throw new IllegalStateException("success method should not be called multiple times");
        }

        protected void callSuccessCallbacks(S result) {
        }

        protected State<S> getFailureState(Throwable failure) {
            throw new IllegalStateException("failure method should not be called multiple times");
        }

        protected void callFailureCallbacks(Throwable failure) {
        }

        protected boolean isCompleted() {
            return true;
        }
    }
}

